<?php

declare(strict_types=1);

namespace SellingPartnerApi\Seller\SolicitationsV1\Requests;

use Exception;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\SolicitationsV1\Responses\CreateProductReviewAndSellerFeedbackSolicitationResponse;

/**
 * createProductReviewAndSellerFeedbackSolicitation
 */
class CreateProductReviewAndSellerFeedbackSolicitation extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * @param  string  $amazonOrderId  An Amazon order identifier. This specifies the order for which a solicitation is sent.
     * @param  array  $marketplaceIds  A marketplace identifier. This specifies the marketplace in which the order was placed. Only one marketplace can be specified.
     */
    public function __construct(
        protected string $amazonOrderId,
        protected array $marketplaceIds,
    ) {
    }

    public function defaultQuery(): array
    {
        return array_filter(['marketplaceIds' => $this->marketplaceIds]);
    }

    public function resolveEndpoint(): string
    {
        return "/solicitations/v1/orders/{$this->amazonOrderId}/solicitations/productReviewAndSellerFeedback";
    }

    public function createDtoFromResponse(Response $response): CreateProductReviewAndSellerFeedbackSolicitationResponse
    {
        $status = $response->status();
        $responseCls = match ($status) {
            201, 400, 403, 404, 413, 415, 429, 500, 503 => CreateProductReviewAndSellerFeedbackSolicitationResponse::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        return $responseCls::deserialize($response->json(), $responseCls);
    }
}
