<?php

declare(strict_types=1);

namespace SellingPartnerApi\Seller\ProductPricingV0\Dto;

use SellingPartnerApi\Dto;
use SellingPartnerApi\Seller\ProductPricingV0\Responses\GetOffersResponse;

final class BatchOffersResponse extends Dto
{
    /**
     * @param  GetOffersResponse  $body  The response schema for the `getListingOffers` and `getItemOffers` operations.
     * @param  ?HttpResponseHeaders  $headers  A mapping of additional HTTP headers to send/receive for the individual batch request.
     * @param  ?GetOffersHttpStatusLine  $status  The HTTP status line associated with the response.  For more information, consult [RFC 2616](https://www.w3.org/Protocols/rfc2616/rfc2616-sec6.html).
     */
    public function __construct(
        public readonly GetOffersResponse $body,
        public readonly ?HttpResponseHeaders $headers = null,
        public readonly ?GetOffersHttpStatusLine $status = null,
    ) {
    }
}
