<?php

declare(strict_types=1);

namespace SellingPartnerApi\Seller\OrdersV0\Dto;

use SellingPartnerApi\Dto;

final class UpdateVerificationStatusRequestBody extends Dto
{
    /**
     * @param  string  $status  The verification status of the order.
     * @param  string  $externalReviewerId  The identifier for the order's regulated information reviewer.
     * @param  ?string  $rejectionReasonId  The unique identifier for the rejection reason used for rejecting the order's regulated information. Only required if the new status is rejected.
     */
    public function __construct(
        public readonly string $status,
        public readonly string $externalReviewerId,
        public readonly ?string $rejectionReasonId = null,
    ) {
    }
}
