<?php

declare(strict_types=1);

namespace SellingPartnerApi\Seller\ListingsItemsV20200901\Responses;

use SellingPartnerApi\Response;
use SellingPartnerApi\Seller\ListingsItemsV20200901\Dto\Issue;

final class ListingsItemSubmissionResponse extends Response
{
    protected static array $complexArrayTypes = ['issues' => [Issue::class]];

    /**
     * @param  string  $sku  A selling partner provided identifier for an Amazon listing.
     * @param  string  $status  The status of the listings item submission.
     * @param  string  $submissionId  The unique identifier of the listings item submission.
     * @param  Issue[]|null  $issues  Listings item issues related to the listings item submission.
     */
    public function __construct(
        public readonly string $sku,
        public readonly string $status,
        public readonly string $submissionId,
        public readonly ?array $issues = null,
    ) {
    }
}
