<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: Crescat\SaloonSdkGenerator\Generators\DtoGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Vendor\DirectFulfillmentOrdersV1\Dto;

use SellingPartnerApi\Dto;

final class OrderAcknowledgementItem extends Dto
{
    protected static array $complexArrayTypes = ['itemAcknowledgements' => OrderItemAcknowledgement::class];

    /**
     * @param  string  $purchaseOrderNumber  The purchase order number for this order. Formatting Notes: alpha-numeric code.
     * @param  string  $vendorOrderNumber  The vendor's order number for this order.
     * @param  \DateTimeInterface  $acknowledgementDate  The date and time when the order is acknowledged, in ISO-8601 date/time format. For example: 2018-07-16T23:00:00Z / 2018-07-16T23:00:00-05:00 / 2018-07-16T23:00:00-08:00.
     * @param  AcknowledgementStatus  $acknowledgementStatus  Status of acknowledgement.
     * @param  PartyIdentification  $sellingParty  Name, address, and tax details of a party.
     * @param  PartyIdentification  $shipFromParty  Name, address, and tax details of a party.
     * @param  OrderItemAcknowledgement[]  $itemAcknowledgements  Item details including acknowledged quantity.
     */
    public function __construct(
        public readonly string $purchaseOrderNumber,
        public readonly string $vendorOrderNumber,
        public readonly \DateTimeInterface $acknowledgementDate,
        public readonly AcknowledgementStatus $acknowledgementStatus,
        public readonly PartyIdentification $sellingParty,
        public readonly PartyIdentification $shipFromParty,
        public readonly array $itemAcknowledgements,
    ) {}
}
