<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\RequestGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\ShippingV2\Requests;

use Exception;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\ShippingV2\Dto\GetRatesRequest;
use SellingPartnerApi\Seller\ShippingV2\Responses\ErrorList;
use SellingPartnerApi\Seller\ShippingV2\Responses\GetRatesResponse;

/**
 * getRates
 */
class GetRates extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * @param  GetRatesRequest  $getRatesRequest  The request schema for the getRates operation. When the channelType is Amazon, the shipTo address is not required and will be ignored.
     * @param  ?string  $xAmznShippingBusinessId  Amazon shipping business to assume for this request. The default is AmazonShipping_UK.
     */
    public function __construct(
        public GetRatesRequest $getRatesRequest,
        protected ?string $xAmznShippingBusinessId = null,
    ) {}

    public function resolveEndpoint(): string
    {
        return '/shipping/v2/shipments/rates';
    }

    public function createDtoFromResponse(Response $response): GetRatesResponse|ErrorList
    {
        $status = $response->status();
        $responseCls = match ($status) {
            200 => GetRatesResponse::class,
            400, 401, 403, 404, 413, 415, 429, 500, 503 => ErrorList::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        return $responseCls::deserialize($response->json());
    }

    public function defaultBody(): array
    {
        return $this->getRatesRequest->toArray();
    }

    public function defaultHeaders(): array
    {
        return array_filter(['x-amzn-shipping-business-id' => $this->xAmznShippingBusinessId]);
    }
}
