<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\RequestGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\ProductFeesV0\Requests;

use Exception;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\ProductFeesV0\Dto\FeesEstimateResult;
use SellingPartnerApi\Seller\ProductFeesV0\Responses\GetMyFeesEstimatesErrorList;

/**
 * getMyFeesEstimates
 */
class GetMyFeesEstimates extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * @param  FeesEstimateByIdRequest[]  $getMyFeesEstimatesRequest  Request for estimated fees for a list of products.
     */
    public function __construct(
        public array $getMyFeesEstimatesRequest,
    ) {}

    public function resolveEndpoint(): string
    {
        return '/products/fees/v0/feesEstimate';
    }

    /**
     * @return FeesEstimateResult[]|GetMyFeesEstimatesErrorList
     */
    public function createDtoFromResponse(Response $response): array|GetMyFeesEstimatesErrorList
    {
        $status = $response->status();
        $responseCls = match ($status) {
            200 => [FeesEstimateResult::class],
            400, 401, 403, 404, 429, 500, 503 => GetMyFeesEstimatesErrorList::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        if (is_array($responseCls)) {
            return array_map(fn ($el) => $responseCls[0]::deserialize($el), $response->json());
        } else {
            return $responseCls::deserialize($response->json());
        }
    }

    public function defaultBody(): array
    {
        return array_map(fn ($item) => $item->toArray(), $this->getMyFeesEstimatesRequest);
    }
}
