<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\RequestGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\DataKioskV20231115\Requests;

use Exception;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\DataKioskV20231115\Responses\ErrorList;
use SellingPartnerApi\Seller\DataKioskV20231115\Responses\Query;

/**
 * getQuery
 */
class GetQuery extends Request
{
    protected Method $method = Method::GET;

    /**
     * @param  string  $queryId  The query identifier.
     */
    public function __construct(
        protected string $queryId,
    ) {}

    public function resolveEndpoint(): string
    {
        return "/dataKiosk/2023-11-15/queries/{$this->queryId}";
    }

    public function createDtoFromResponse(Response $response): Query|ErrorList
    {
        $status = $response->status();
        $responseCls = match ($status) {
            200 => Query::class,
            400, 403, 404, 413, 415, 429, 500, 503 => ErrorList::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        return $responseCls::deserialize($response->json());
    }
}
