<?php
/**
 * TransportationDetails
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * TransportationDetails Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class TransportationDetails extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransportationDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ship_mode' => 'string',
        'transportation_mode' => 'string',
        'shipped_date' => 'string',
        'estimated_delivery_date' => 'string',
        'shipment_delivery_date' => 'string',
        'carrier_details' => '\SellingPartnerApi\Model\VendorShippingV1\CarrierDetails',
        'bill_of_lading_number' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ship_mode' => null,
        'transportation_mode' => null,
        'shipped_date' => null,
        'estimated_delivery_date' => null,
        'shipment_delivery_date' => null,
        'carrier_details' => null,
        'bill_of_lading_number' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ship_mode' => 'shipMode',
        'transportation_mode' => 'transportationMode',
        'shipped_date' => 'shippedDate',
        'estimated_delivery_date' => 'estimatedDeliveryDate',
        'shipment_delivery_date' => 'shipmentDeliveryDate',
        'carrier_details' => 'carrierDetails',
        'bill_of_lading_number' => 'billOfLadingNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ship_mode' => 'setShipMode',
        'transportation_mode' => 'setTransportationMode',
        'shipped_date' => 'setShippedDate',
        'estimated_delivery_date' => 'setEstimatedDeliveryDate',
        'shipment_delivery_date' => 'setShipmentDeliveryDate',
        'carrier_details' => 'setCarrierDetails',
        'bill_of_lading_number' => 'setBillOfLadingNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ship_mode' => 'getShipMode',
        'transportation_mode' => 'getTransportationMode',
        'shipped_date' => 'getShippedDate',
        'estimated_delivery_date' => 'getEstimatedDeliveryDate',
        'shipment_delivery_date' => 'getShipmentDeliveryDate',
        'carrier_details' => 'getCarrierDetails',
        'bill_of_lading_number' => 'getBillOfLadingNumber'
    ];



    const SHIP_MODE_TRUCK_LOAD = 'TruckLoad';
    const SHIP_MODE_LESS_THAN_TRUCK_LOAD = 'LessThanTruckLoad';
    const SHIP_MODE_SMALL_PARCEL = 'SmallParcel';
    

    const TRANSPORTATION_MODE_ROAD = 'Road';
    const TRANSPORTATION_MODE_AIR = 'Air';
    const TRANSPORTATION_MODE_OCEAN = 'Ocean';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getShipModeAllowableValues()
    {
        $baseVals = [
            self::SHIP_MODE_TRUCK_LOAD,
            self::SHIP_MODE_LESS_THAN_TRUCK_LOAD,
            self::SHIP_MODE_SMALL_PARCEL,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTransportationModeAllowableValues()
    {
        $baseVals = [
            self::TRANSPORTATION_MODE_ROAD,
            self::TRANSPORTATION_MODE_AIR,
            self::TRANSPORTATION_MODE_OCEAN,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['ship_mode'] = $data['ship_mode'] ?? null;
        $this->container['transportation_mode'] = $data['transportation_mode'] ?? null;
        $this->container['shipped_date'] = $data['shipped_date'] ?? null;
        $this->container['estimated_delivery_date'] = $data['estimated_delivery_date'] ?? null;
        $this->container['shipment_delivery_date'] = $data['shipment_delivery_date'] ?? null;
        $this->container['carrier_details'] = $data['carrier_details'] ?? null;
        $this->container['bill_of_lading_number'] = $data['bill_of_lading_number'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        $allowedValues = $this->getShipModeAllowableValues();
        if (
            !is_null($this->container['ship_mode']) &&
            !in_array(strtoupper($this->container['ship_mode']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ship_mode', must be one of '%s'",
                $this->container['ship_mode'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTransportationModeAllowableValues();
        if (
            !is_null($this->container['transportation_mode']) &&
            !in_array(strtoupper($this->container['transportation_mode']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'transportation_mode', must be one of '%s'",
                $this->container['transportation_mode'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets ship_mode
     *
     * @return string|null
     */
    public function getShipMode()
    {
        return $this->container['ship_mode'];
    }

    /**
     * Sets ship_mode
     *
     * @param string|null $ship_mode The type of shipment.
     *
     * @return self
     */
    public function setShipMode($ship_mode)
    {
        $allowedValues = $this->getShipModeAllowableValues();
        if (!is_null($ship_mode) &&!in_array(strtoupper($ship_mode), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ship_mode', must be one of '%s'",
                    $ship_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ship_mode'] = $ship_mode;

        return $this;
    }
    /**
     * Gets transportation_mode
     *
     * @return string|null
     */
    public function getTransportationMode()
    {
        return $this->container['transportation_mode'];
    }

    /**
     * Sets transportation_mode
     *
     * @param string|null $transportation_mode The mode of transportation for this shipment.
     *
     * @return self
     */
    public function setTransportationMode($transportation_mode)
    {
        $allowedValues = $this->getTransportationModeAllowableValues();
        if (!is_null($transportation_mode) &&!in_array(strtoupper($transportation_mode), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'transportation_mode', must be one of '%s'",
                    $transportation_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['transportation_mode'] = $transportation_mode;

        return $this;
    }
    /**
     * Gets shipped_date
     *
     * @return string|null
     */
    public function getShippedDate()
    {
        return $this->container['shipped_date'];
    }

    /**
     * Sets shipped_date
     *
     * @param string|null $shipped_date Date when shipment is performed by the Vendor to Buyer
     *
     * @return self
     */
    public function setShippedDate($shipped_date)
    {
        $this->container['shipped_date'] = $shipped_date;

        return $this;
    }
    /**
     * Gets estimated_delivery_date
     *
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->container['estimated_delivery_date'];
    }

    /**
     * Sets estimated_delivery_date
     *
     * @param string|null $estimated_delivery_date Estimated Date on which shipment will be delivered from Vendor to Buyer
     *
     * @return self
     */
    public function setEstimatedDeliveryDate($estimated_delivery_date)
    {
        $this->container['estimated_delivery_date'] = $estimated_delivery_date;

        return $this;
    }
    /**
     * Gets shipment_delivery_date
     *
     * @return string|null
     */
    public function getShipmentDeliveryDate()
    {
        return $this->container['shipment_delivery_date'];
    }

    /**
     * Sets shipment_delivery_date
     *
     * @param string|null $shipment_delivery_date Date on which shipment will be delivered from Vendor to Buyer
     *
     * @return self
     */
    public function setShipmentDeliveryDate($shipment_delivery_date)
    {
        $this->container['shipment_delivery_date'] = $shipment_delivery_date;

        return $this;
    }
    /**
     * Gets carrier_details
     *
     * @return \SellingPartnerApi\Model\VendorShippingV1\CarrierDetails|null
     */
    public function getCarrierDetails()
    {
        return $this->container['carrier_details'];
    }

    /**
     * Sets carrier_details
     *
     * @param \SellingPartnerApi\Model\VendorShippingV1\CarrierDetails|null $carrier_details carrier_details
     *
     * @return self
     */
    public function setCarrierDetails($carrier_details)
    {
        $this->container['carrier_details'] = $carrier_details;

        return $this;
    }
    /**
     * Gets bill_of_lading_number
     *
     * @return string|null
     */
    public function getBillOfLadingNumber()
    {
        return $this->container['bill_of_lading_number'];
    }

    /**
     * Sets bill_of_lading_number
     *
     * @param string|null $bill_of_lading_number Bill Of Lading (BOL) number is the unique number assigned by the vendor. The BOL present in the Shipment Confirmation message ideally matches the paper BOL provided with the shipment, but that is no must. Instead of BOL, an alternative reference number (like Delivery Note Number) for the shipment can also be sent in this field.
     *
     * @return self
     */
    public function setBillOfLadingNumber($bill_of_lading_number)
    {
        $this->container['bill_of_lading_number'] = $bill_of_lading_number;

        return $this;
    }
}


