<?php
/**
 * ItemApprovalContext
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ItemApprovalContext Class Doc Comment
 *
 * @category Class
 * @description Generic item approval context. Check the applicable restrictions at the specific approval type schemas.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemApprovalContext extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemApprovalContext';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'approval_type' => '\SellingPartnerApi\Model\OrdersV0\ItemApprovalType',
        'approval_status' => '\SellingPartnerApi\Model\OrdersV0\ItemApprovalStatus',
        'approval_support_data' => '\SellingPartnerApi\Model\OrdersV0\ApprovalSupportDataElement[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'approval_type' => null,
        'approval_status' => null,
        'approval_support_data' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'approval_type' => 'ApprovalType',
        'approval_status' => 'ApprovalStatus',
        'approval_support_data' => 'ApprovalSupportData'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'approval_type' => 'setApprovalType',
        'approval_status' => 'setApprovalStatus',
        'approval_support_data' => 'setApprovalSupportData'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'approval_type' => 'getApprovalType',
        'approval_status' => 'getApprovalStatus',
        'approval_support_data' => 'getApprovalSupportData'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['approval_type'] = $data['approval_type'] ?? null;
        $this->container['approval_status'] = $data['approval_status'] ?? null;
        $this->container['approval_support_data'] = $data['approval_support_data'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['approval_type'] === null) {
            $invalidProperties[] = "'approval_type' can't be null";
        }
        if ($this->container['approval_status'] === null) {
            $invalidProperties[] = "'approval_status' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets approval_type
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemApprovalType
     */
    public function getApprovalType()
    {
        return $this->container['approval_type'];
    }

    /**
     * Sets approval_type
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemApprovalType $approval_type approval_type
     *
     * @return self
     */
    public function setApprovalType($approval_type)
    {
        $this->container['approval_type'] = $approval_type;

        return $this;
    }
    /**
     * Gets approval_status
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemApprovalStatus
     */
    public function getApprovalStatus()
    {
        return $this->container['approval_status'];
    }

    /**
     * Sets approval_status
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemApprovalStatus $approval_status approval_status
     *
     * @return self
     */
    public function setApprovalStatus($approval_status)
    {
        $this->container['approval_status'] = $approval_status;

        return $this;
    }
    /**
     * Gets approval_support_data
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ApprovalSupportDataElement[]|null
     */
    public function getApprovalSupportData()
    {
        return $this->container['approval_support_data'];
    }

    /**
     * Sets approval_support_data
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ApprovalSupportDataElement[]|null $approval_support_data List of additional data elements supporting the approval process. Check the applicable restrictions at the specific approval type schemas.
     *
     * @return self
     */
    public function setApprovalSupportData($approval_support_data)
    {
        $this->container['approval_support_data'] = $approval_support_data;

        return $this;
    }
}


