<?php
/**
 * ItemApproval
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ItemApproval Class Doc Comment
 *
 * @category Class
 * @description Generic item approval. Check the applicable restrictions at the specific approval type schemas.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemApproval extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemApproval';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sequence_id' => 'int',
        'timestamp' => 'string',
        'actor' => 'string',
        'approver' => 'string',
        'approval_action' => '\SellingPartnerApi\Model\OrdersV0\ItemApprovalAction',
        'approval_action_process_status' => 'string',
        'approval_action_process_status_message' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sequence_id' => null,
        'timestamp' => null,
        'actor' => null,
        'approver' => null,
        'approval_action' => null,
        'approval_action_process_status' => null,
        'approval_action_process_status_message' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sequence_id' => 'SequenceId',
        'timestamp' => 'Timestamp',
        'actor' => 'Actor',
        'approver' => 'Approver',
        'approval_action' => 'ApprovalAction',
        'approval_action_process_status' => 'ApprovalActionProcessStatus',
        'approval_action_process_status_message' => 'ApprovalActionProcessStatusMessage'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sequence_id' => 'setSequenceId',
        'timestamp' => 'setTimestamp',
        'actor' => 'setActor',
        'approver' => 'setApprover',
        'approval_action' => 'setApprovalAction',
        'approval_action_process_status' => 'setApprovalActionProcessStatus',
        'approval_action_process_status_message' => 'setApprovalActionProcessStatusMessage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sequence_id' => 'getSequenceId',
        'timestamp' => 'getTimestamp',
        'actor' => 'getActor',
        'approver' => 'getApprover',
        'approval_action' => 'getApprovalAction',
        'approval_action_process_status' => 'getApprovalActionProcessStatus',
        'approval_action_process_status_message' => 'getApprovalActionProcessStatusMessage'
    ];



    const ACTOR_SELLING_PARTNER = 'SELLING_PARTNER';
    const ACTOR_AMAZON = 'AMAZON';
    

    const APPROVAL_ACTION_PROCESS_STATUS_PROCESSING = 'PROCESSING';
    const APPROVAL_ACTION_PROCESS_STATUS_SUCCESS = 'SUCCESS';
    const APPROVAL_ACTION_PROCESS_STATUS_ERROR = 'ERROR';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getActorAllowableValues()
    {
        $baseVals = [
            self::ACTOR_SELLING_PARTNER,
            self::ACTOR_AMAZON,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getApprovalActionProcessStatusAllowableValues()
    {
        $baseVals = [
            self::APPROVAL_ACTION_PROCESS_STATUS_PROCESSING,
            self::APPROVAL_ACTION_PROCESS_STATUS_SUCCESS,
            self::APPROVAL_ACTION_PROCESS_STATUS_ERROR,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['sequence_id'] = $data['sequence_id'] ?? null;
        $this->container['timestamp'] = $data['timestamp'] ?? null;
        $this->container['actor'] = $data['actor'] ?? null;
        $this->container['approver'] = $data['approver'] ?? null;
        $this->container['approval_action'] = $data['approval_action'] ?? null;
        $this->container['approval_action_process_status'] = $data['approval_action_process_status'] ?? null;
        $this->container['approval_action_process_status_message'] = $data['approval_action_process_status_message'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['sequence_id'] === null) {
            $invalidProperties[] = "'sequence_id' can't be null";
        }
        if ($this->container['timestamp'] === null) {
            $invalidProperties[] = "'timestamp' can't be null";
        }
        if ($this->container['actor'] === null) {
            $invalidProperties[] = "'actor' can't be null";
        }
        $allowedValues = $this->getActorAllowableValues();
        if (
            !is_null($this->container['actor']) &&
            !in_array(strtoupper($this->container['actor']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'actor', must be one of '%s'",
                $this->container['actor'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['approval_action'] === null) {
            $invalidProperties[] = "'approval_action' can't be null";
        }
        if ($this->container['approval_action_process_status'] === null) {
            $invalidProperties[] = "'approval_action_process_status' can't be null";
        }
        $allowedValues = $this->getApprovalActionProcessStatusAllowableValues();
        if (
            !is_null($this->container['approval_action_process_status']) &&
            !in_array(strtoupper($this->container['approval_action_process_status']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'approval_action_process_status', must be one of '%s'",
                $this->container['approval_action_process_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets sequence_id
     *
     * @return int
     */
    public function getSequenceId()
    {
        return $this->container['sequence_id'];
    }

    /**
     * Sets sequence_id
     *
     * @param int $sequence_id Sequence number of the item approval. Each ItemApproval gets its sequenceId automatically from a monotonic increasing function.
     *
     * @return self
     */
    public function setSequenceId($sequence_id)
    {
        $this->container['sequence_id'] = $sequence_id;

        return $this;
    }
    /**
     * Gets timestamp
     *
     * @return string
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     *
     * @param string $timestamp Timestamp when the ItemApproval was recorded by Amazon's internal order approvals system. In ISO 8601 date time format.
     *
     * @return self
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }
    /**
     * Gets actor
     *
     * @return string
     */
    public function getActor()
    {
        return $this->container['actor'];
    }

    /**
     * Sets actor
     *
     * @param string $actor High level actors involved in the approval process.
     *
     * @return self
     */
    public function setActor($actor)
    {
        $allowedValues = $this->getActorAllowableValues();
        if (!in_array(strtoupper($actor), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'actor', must be one of '%s'",
                    $actor,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['actor'] = $actor;

        return $this;
    }
    /**
     * Gets approver
     *
     * @return string|null
     */
    public function getApprover()
    {
        return $this->container['approver'];
    }

    /**
     * Sets approver
     *
     * @param string|null $approver Person or system that triggers the approval actions on behalf of the actor.
     *
     * @return self
     */
    public function setApprover($approver)
    {
        $this->container['approver'] = $approver;

        return $this;
    }
    /**
     * Gets approval_action
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemApprovalAction
     */
    public function getApprovalAction()
    {
        return $this->container['approval_action'];
    }

    /**
     * Sets approval_action
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemApprovalAction $approval_action approval_action
     *
     * @return self
     */
    public function setApprovalAction($approval_action)
    {
        $this->container['approval_action'] = $approval_action;

        return $this;
    }
    /**
     * Gets approval_action_process_status
     *
     * @return string
     */
    public function getApprovalActionProcessStatus()
    {
        return $this->container['approval_action_process_status'];
    }

    /**
     * Sets approval_action_process_status
     *
     * @param string $approval_action_process_status Status of approval action.
     *
     * @return self
     */
    public function setApprovalActionProcessStatus($approval_action_process_status)
    {
        $allowedValues = $this->getApprovalActionProcessStatusAllowableValues();
        if (!in_array(strtoupper($approval_action_process_status), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'approval_action_process_status', must be one of '%s'",
                    $approval_action_process_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['approval_action_process_status'] = $approval_action_process_status;

        return $this;
    }
    /**
     * Gets approval_action_process_status_message
     *
     * @return string|null
     */
    public function getApprovalActionProcessStatusMessage()
    {
        return $this->container['approval_action_process_status_message'];
    }

    /**
     * Sets approval_action_process_status_message
     *
     * @param string|null $approval_action_process_status_message Optional message to communicate optional additional context about the current status of the approval action.
     *
     * @return self
     */
    public function setApprovalActionProcessStatusMessage($approval_action_process_status_message)
    {
        $this->container['approval_action_process_status_message'] = $approval_action_process_status_message;

        return $this;
    }
}


