<?php
/**
 * ConfirmShipmentRequest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ConfirmShipmentRequest Class Doc Comment
 *
 * @category Class
 * @description The request schema for an shipment confirmation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ConfirmShipmentRequest extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ConfirmShipmentRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'package_detail' => '\SellingPartnerApi\Model\OrdersV0\PackageDetail',
        'cod_collection_method' => 'string',
        'marketplace_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'package_detail' => null,
        'cod_collection_method' => null,
        'marketplace_id' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'package_detail' => 'packageDetail',
        'cod_collection_method' => 'codCollectionMethod',
        'marketplace_id' => 'marketplaceId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'package_detail' => 'setPackageDetail',
        'cod_collection_method' => 'setCodCollectionMethod',
        'marketplace_id' => 'setMarketplaceId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'package_detail' => 'getPackageDetail',
        'cod_collection_method' => 'getCodCollectionMethod',
        'marketplace_id' => 'getMarketplaceId'
    ];



    const COD_COLLECTION_METHOD_DIRECT_PAYMENT = 'DirectPayment';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCodCollectionMethodAllowableValues()
    {
        $baseVals = [
            self::COD_COLLECTION_METHOD_DIRECT_PAYMENT,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['package_detail'] = $data['package_detail'] ?? null;
        $this->container['cod_collection_method'] = $data['cod_collection_method'] ?? null;
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['package_detail'] === null) {
            $invalidProperties[] = "'package_detail' can't be null";
        }
        $allowedValues = $this->getCodCollectionMethodAllowableValues();
        if (
            !is_null($this->container['cod_collection_method']) &&
            !in_array(strtoupper($this->container['cod_collection_method']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'cod_collection_method', must be one of '%s'",
                $this->container['cod_collection_method'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets package_detail
     *
     * @return \SellingPartnerApi\Model\OrdersV0\PackageDetail
     */
    public function getPackageDetail()
    {
        return $this->container['package_detail'];
    }

    /**
     * Sets package_detail
     *
     * @param \SellingPartnerApi\Model\OrdersV0\PackageDetail $package_detail package_detail
     *
     * @return self
     */
    public function setPackageDetail($package_detail)
    {
        $this->container['package_detail'] = $package_detail;

        return $this;
    }
    /**
     * Gets cod_collection_method
     *
     * @return string|null
     */
    public function getCodCollectionMethod()
    {
        return $this->container['cod_collection_method'];
    }

    /**
     * Sets cod_collection_method
     *
     * @param string|null $cod_collection_method The cod collection method, support in JP only.
     *
     * @return self
     */
    public function setCodCollectionMethod($cod_collection_method)
    {
        $allowedValues = $this->getCodCollectionMethodAllowableValues();
        if (!is_null($cod_collection_method) &&!in_array(strtoupper($cod_collection_method), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'cod_collection_method', must be one of '%s'",
                    $cod_collection_method,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['cod_collection_method'] = $cod_collection_method;

        return $this;
    }
    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id The unobfuscated marketplace identifier.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
}


