<?php
/**
 * ItemRelationship
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Catalog Items
 *
 * The Selling Partner API for Catalog Items provides programmatic access to information about items in the Amazon catalog. For more information, refer to the [Catalog Items API Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/catalog-items-api-v2022-04-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2022-04-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\CatalogItemsV20220401;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ItemRelationship Class Doc Comment
 *
 * @category Class
 * @description Relationship details for an Amazon catalog item.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemRelationship extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemRelationship';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'child_asins' => 'string[]',
        'parent_asins' => 'string[]',
        'variation_theme' => '\SellingPartnerApi\Model\CatalogItemsV20220401\ItemVariationTheme',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'child_asins' => null,
        'parent_asins' => null,
        'variation_theme' => null,
        'type' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'child_asins' => 'childAsins',
        'parent_asins' => 'parentAsins',
        'variation_theme' => 'variationTheme',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'child_asins' => 'setChildAsins',
        'parent_asins' => 'setParentAsins',
        'variation_theme' => 'setVariationTheme',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'child_asins' => 'getChildAsins',
        'parent_asins' => 'getParentAsins',
        'variation_theme' => 'getVariationTheme',
        'type' => 'getType'
    ];



    const TYPE_VARIATION = 'VARIATION';
    const TYPE_PACKAGE_HIERARCHY = 'PACKAGE_HIERARCHY';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        $baseVals = [
            self::TYPE_VARIATION,
            self::TYPE_PACKAGE_HIERARCHY,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['child_asins'] = $data['child_asins'] ?? null;
        $this->container['parent_asins'] = $data['parent_asins'] ?? null;
        $this->container['variation_theme'] = $data['variation_theme'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (
            !is_null($this->container['type']) &&
            !in_array(strtoupper($this->container['type']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets child_asins
     *
     * @return string[]|null
     */
    public function getChildAsins()
    {
        return $this->container['child_asins'];
    }

    /**
     * Sets child_asins
     *
     * @param string[]|null $child_asins Identifiers (ASINs) of the related items that are children of this item.
     *
     * @return self
     */
    public function setChildAsins($child_asins)
    {
        $this->container['child_asins'] = $child_asins;

        return $this;
    }
    /**
     * Gets parent_asins
     *
     * @return string[]|null
     */
    public function getParentAsins()
    {
        return $this->container['parent_asins'];
    }

    /**
     * Sets parent_asins
     *
     * @param string[]|null $parent_asins Identifiers (ASINs) of the related items that are parents of this item.
     *
     * @return self
     */
    public function setParentAsins($parent_asins)
    {
        $this->container['parent_asins'] = $parent_asins;

        return $this;
    }
    /**
     * Gets variation_theme
     *
     * @return \SellingPartnerApi\Model\CatalogItemsV20220401\ItemVariationTheme|null
     */
    public function getVariationTheme()
    {
        return $this->container['variation_theme'];
    }

    /**
     * Sets variation_theme
     *
     * @param \SellingPartnerApi\Model\CatalogItemsV20220401\ItemVariationTheme|null $variation_theme variation_theme
     *
     * @return self
     */
    public function setVariationTheme($variation_theme)
    {
        $this->container['variation_theme'] = $variation_theme;

        return $this;
    }
    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type Type of relationship.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array(strtoupper($type), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }
}


