<?php
/**
 * CartonReferenceDetails
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * CartonReferenceDetails Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class CartonReferenceDetails extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CartonReferenceDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'carton_count' => 'int',
        'carton_reference_numbers' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'carton_count' => null,
        'carton_reference_numbers' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'carton_count' => 'cartonCount',
        'carton_reference_numbers' => 'cartonReferenceNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'carton_count' => 'setCartonCount',
        'carton_reference_numbers' => 'setCartonReferenceNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'carton_count' => 'getCartonCount',
        'carton_reference_numbers' => 'getCartonReferenceNumbers'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['carton_count'] = $data['carton_count'] ?? null;
        $this->container['carton_reference_numbers'] = $data['carton_reference_numbers'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['carton_reference_numbers'] === null) {
            $invalidProperties[] = "'carton_reference_numbers' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets carton_count
     *
     * @return int|null
     */
    public function getCartonCount()
    {
        return $this->container['carton_count'];
    }

    /**
     * Sets carton_count
     *
     * @param int|null $carton_count Pallet level carton count is mandatory for single item pallet and optional for mixed item pallet.
     *
     * @return self
     */
    public function setCartonCount($carton_count)
    {
        $this->container['carton_count'] = $carton_count;

        return $this;
    }
    /**
     * Gets carton_reference_numbers
     *
     * @return string[]
     */
    public function getCartonReferenceNumbers()
    {
        return $this->container['carton_reference_numbers'];
    }

    /**
     * Sets carton_reference_numbers
     *
     * @param string[] $carton_reference_numbers Array of reference numbers for the carton that are part of this pallet/shipment. Please provide the cartonSequenceNumber from the 'cartons' segment to refer to that carton's details here.
     *
     * @return self
     */
    public function setCartonReferenceNumbers($carton_reference_numbers)
    {
        $this->container['carton_reference_numbers'] = $carton_reference_numbers;

        return $this;
    }
}


