<?php
/**
 * BuyerRequestedCancel
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * BuyerRequestedCancel Class Doc Comment
 *
 * @category Class
 * @description Information about whether or not a buyer requested cancellation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class BuyerRequestedCancel extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BuyerRequestedCancel';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'is_buyer_requested_cancel' => 'bool',
        'buyer_cancel_reason' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'is_buyer_requested_cancel' => null,
        'buyer_cancel_reason' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'is_buyer_requested_cancel' => 'IsBuyerRequestedCancel',
        'buyer_cancel_reason' => 'BuyerCancelReason'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'is_buyer_requested_cancel' => 'setIsBuyerRequestedCancel',
        'buyer_cancel_reason' => 'setBuyerCancelReason'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'is_buyer_requested_cancel' => 'getIsBuyerRequestedCancel',
        'buyer_cancel_reason' => 'getBuyerCancelReason'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['is_buyer_requested_cancel'] = $data['is_buyer_requested_cancel'] ?? null;
        $this->container['buyer_cancel_reason'] = $data['buyer_cancel_reason'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets is_buyer_requested_cancel
     *
     * @return bool|null
     */
    public function getIsBuyerRequestedCancel()
    {
        return $this->container['is_buyer_requested_cancel'];
    }

    /**
     * Sets is_buyer_requested_cancel
     *
     * @param bool|null $is_buyer_requested_cancel When true, the buyer has requested cancellation.
     *
     * @return self
     */
    public function setIsBuyerRequestedCancel($is_buyer_requested_cancel)
    {
        $this->container['is_buyer_requested_cancel'] = $is_buyer_requested_cancel;

        return $this;
    }
    /**
     * Gets buyer_cancel_reason
     *
     * @return string|null
     */
    public function getBuyerCancelReason()
    {
        return $this->container['buyer_cancel_reason'];
    }

    /**
     * Sets buyer_cancel_reason
     *
     * @param string|null $buyer_cancel_reason The reason that the buyer requested cancellation.
     *
     * @return self
     */
    public function setBuyerCancelReason($buyer_cancel_reason)
    {
        $this->container['buyer_cancel_reason'] = $buyer_cancel_reason;

        return $this;
    }
}


