<?php
/**
 * TaxWithholdingEvent
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Finances
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FinancesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * TaxWithholdingEvent Class Doc Comment
 *
 * @category Class
 * @description A TaxWithholding event on seller's account.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class TaxWithholdingEvent extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TaxWithholdingEvent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'posted_date' => 'string',
        'base_amount' => '\SellingPartnerApi\Model\FinancesV0\Currency',
        'withheld_amount' => '\SellingPartnerApi\Model\FinancesV0\Currency',
        'tax_withholding_period' => '\SellingPartnerApi\Model\FinancesV0\TaxWithholdingPeriod'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'posted_date' => null,
        'base_amount' => null,
        'withheld_amount' => null,
        'tax_withholding_period' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'posted_date' => 'PostedDate',
        'base_amount' => 'BaseAmount',
        'withheld_amount' => 'WithheldAmount',
        'tax_withholding_period' => 'TaxWithholdingPeriod'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'posted_date' => 'setPostedDate',
        'base_amount' => 'setBaseAmount',
        'withheld_amount' => 'setWithheldAmount',
        'tax_withholding_period' => 'setTaxWithholdingPeriod'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'posted_date' => 'getPostedDate',
        'base_amount' => 'getBaseAmount',
        'withheld_amount' => 'getWithheldAmount',
        'tax_withholding_period' => 'getTaxWithholdingPeriod'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['posted_date'] = $data['posted_date'] ?? null;
        $this->container['base_amount'] = $data['base_amount'] ?? null;
        $this->container['withheld_amount'] = $data['withheld_amount'] ?? null;
        $this->container['tax_withholding_period'] = $data['tax_withholding_period'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets posted_date
     *
     * @return string|null
     */
    public function getPostedDate()
    {
        return $this->container['posted_date'];
    }

    /**
     * Sets posted_date
     *
     * @param string|null $posted_date A date string in ISO 8601 format.
     *
     * @return self
     */
    public function setPostedDate($posted_date)
    {
        $this->container['posted_date'] = $posted_date;

        return $this;
    }
    /**
     * Gets base_amount
     *
     * @return \SellingPartnerApi\Model\FinancesV0\Currency|null
     */
    public function getBaseAmount()
    {
        return $this->container['base_amount'];
    }

    /**
     * Sets base_amount
     *
     * @param \SellingPartnerApi\Model\FinancesV0\Currency|null $base_amount base_amount
     *
     * @return self
     */
    public function setBaseAmount($base_amount)
    {
        $this->container['base_amount'] = $base_amount;

        return $this;
    }
    /**
     * Gets withheld_amount
     *
     * @return \SellingPartnerApi\Model\FinancesV0\Currency|null
     */
    public function getWithheldAmount()
    {
        return $this->container['withheld_amount'];
    }

    /**
     * Sets withheld_amount
     *
     * @param \SellingPartnerApi\Model\FinancesV0\Currency|null $withheld_amount withheld_amount
     *
     * @return self
     */
    public function setWithheldAmount($withheld_amount)
    {
        $this->container['withheld_amount'] = $withheld_amount;

        return $this;
    }
    /**
     * Gets tax_withholding_period
     *
     * @return \SellingPartnerApi\Model\FinancesV0\TaxWithholdingPeriod|null
     */
    public function getTaxWithholdingPeriod()
    {
        return $this->container['tax_withholding_period'];
    }

    /**
     * Sets tax_withholding_period
     *
     * @param \SellingPartnerApi\Model\FinancesV0\TaxWithholdingPeriod|null $tax_withholding_period tax_withholding_period
     *
     * @return self
     */
    public function setTaxWithholdingPeriod($tax_withholding_period)
    {
        $this->container['tax_withholding_period'] = $tax_withholding_period;

        return $this;
    }
}


