<?php
/**
 * FeaturedOfferExpectedPriceResponseBody
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Pricing
 *
 * The Selling Partner API for Pricing helps you programmatically retrieve product pricing and offer pricing information for Amazon Marketplace products. For more information, see the [Product Pricing v2022-05-01 Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/product-pricing-api-v2022-05-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2022-05-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ProductPricingV20220501;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * FeaturedOfferExpectedPriceResponseBody Class Doc Comment
 *
 * @category Class
 * @description The featured offer expected price response data for a requested SKU.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class FeaturedOfferExpectedPriceResponseBody extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FeaturedOfferExpectedPriceResponseBody';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'offer_identifier' => '\SellingPartnerApi\Model\ProductPricingV20220501\OfferIdentifier',
        'featured_offer_expected_price_results' => '\SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOfferExpectedPriceResult[]',
        'errors' => '\SellingPartnerApi\Model\ProductPricingV20220501\Error[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'offer_identifier' => null,
        'featured_offer_expected_price_results' => null,
        'errors' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'offer_identifier' => 'offerIdentifier',
        'featured_offer_expected_price_results' => 'featuredOfferExpectedPriceResults',
        'errors' => 'errors'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'offer_identifier' => 'setOfferIdentifier',
        'featured_offer_expected_price_results' => 'setFeaturedOfferExpectedPriceResults',
        'errors' => 'setErrors'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'offer_identifier' => 'getOfferIdentifier',
        'featured_offer_expected_price_results' => 'getFeaturedOfferExpectedPriceResults',
        'errors' => 'getErrors'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['offer_identifier'] = $data['offer_identifier'] ?? null;
        $this->container['featured_offer_expected_price_results'] = $data['featured_offer_expected_price_results'] ?? null;
        $this->container['errors'] = $data['errors'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['offer_identifier'] === null) {
            $invalidProperties[] = "'offer_identifier' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets offer_identifier
     *
     * @return \SellingPartnerApi\Model\ProductPricingV20220501\OfferIdentifier
     */
    public function getOfferIdentifier()
    {
        return $this->container['offer_identifier'];
    }

    /**
     * Sets offer_identifier
     *
     * @param \SellingPartnerApi\Model\ProductPricingV20220501\OfferIdentifier $offer_identifier offer_identifier
     *
     * @return self
     */
    public function setOfferIdentifier($offer_identifier)
    {
        $this->container['offer_identifier'] = $offer_identifier;

        return $this;
    }
    /**
     * Gets featured_offer_expected_price_results
     *
     * @return \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOfferExpectedPriceResult[]|null
     */
    public function getFeaturedOfferExpectedPriceResults()
    {
        return $this->container['featured_offer_expected_price_results'];
    }

    /**
     * Sets featured_offer_expected_price_results
     *
     * @param \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOfferExpectedPriceResult[]|null $featured_offer_expected_price_results A list of featured offer expected price results for the requested offer.
     *
     * @return self
     */
    public function setFeaturedOfferExpectedPriceResults($featured_offer_expected_price_results)
    {
        $this->container['featured_offer_expected_price_results'] = $featured_offer_expected_price_results;

        return $this;
    }
    /**
     * Gets errors
     *
     * @return \SellingPartnerApi\Model\ProductPricingV20220501\Error[]|null
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param \SellingPartnerApi\Model\ProductPricingV20220501\Error[]|null $errors A list of error responses returned when a request is unsuccessful.
     *
     * @return self
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }
}


