<?php
/**
 * PrimeInformationType
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Pricing
 *
 * The Selling Partner API for Pricing helps you programmatically retrieve product pricing and offer information for Amazon Marketplace products.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ProductPricingV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * PrimeInformationType Class Doc Comment
 *
 * @category Class
 * @description Amazon Prime information.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class PrimeInformationType extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PrimeInformationType';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'is_prime' => 'bool',
        'is_national_prime' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'is_prime' => null,
        'is_national_prime' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'is_prime' => 'IsPrime',
        'is_national_prime' => 'IsNationalPrime'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'is_prime' => 'setIsPrime',
        'is_national_prime' => 'setIsNationalPrime'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'is_prime' => 'getIsPrime',
        'is_national_prime' => 'getIsNationalPrime'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['is_prime'] = $data['is_prime'] ?? null;
        $this->container['is_national_prime'] = $data['is_national_prime'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['is_prime'] === null) {
            $invalidProperties[] = "'is_prime' can't be null";
        }
        if ($this->container['is_national_prime'] === null) {
            $invalidProperties[] = "'is_national_prime' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets is_prime
     *
     * @return bool
     */
    public function getIsPrime()
    {
        return $this->container['is_prime'];
    }

    /**
     * Sets is_prime
     *
     * @param bool $is_prime Indicates whether the offer is an Amazon Prime offer.
     *
     * @return self
     */
    public function setIsPrime($is_prime)
    {
        $this->container['is_prime'] = $is_prime;

        return $this;
    }
    /**
     * Gets is_national_prime
     *
     * @return bool
     */
    public function getIsNationalPrime()
    {
        return $this->container['is_national_prime'];
    }

    /**
     * Sets is_national_prime
     *
     * @param bool $is_national_prime Indicates whether the offer is an Amazon Prime offer throughout the entire marketplace where it is listed.
     *
     * @return self
     */
    public function setIsNationalPrime($is_national_prime)
    {
        $this->container['is_national_prime'] = $is_national_prime;

        return $this;
    }
}


