<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\ResponseGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\AmazonWarehousingAndDistributionV20240509\Responses;

use SellingPartnerApi\Response;
use SellingPartnerApi\Seller\AmazonWarehousingAndDistributionV20240509\Dto\Address;
use SellingPartnerApi\Seller\AmazonWarehousingAndDistributionV20240509\Dto\CarrierCode;
use SellingPartnerApi\Seller\AmazonWarehousingAndDistributionV20240509\Dto\DistributionPackageQuantity;
use SellingPartnerApi\Seller\AmazonWarehousingAndDistributionV20240509\Dto\InventoryQuantity;

final class InboundShipment extends Response
{
    protected static array $complexArrayTypes = [
        'shipmentContainerQuantities' => DistributionPackageQuantity::class,
        'receivedQuantity' => InventoryQuantity::class,
    ];

    /**
     * @param  Address  $destinationAddress  Shipping address that represents the origin or destination location.
     * @param  string  $orderId  The AWD inbound order ID that this inbound shipment belongs to.
     * @param  Address  $originAddress  Shipping address that represents the origin or destination location.
     * @param  DistributionPackageQuantity[]  $shipmentContainerQuantities  Packages that are part of this shipment.
     * @param  string  $shipmentId  Unique shipment ID.
     * @param  string  $shipmentStatus  Possible shipment statuses used by shipments.
     * @param  ?CarrierCode  $carrierCode  Identifies the carrier that will deliver the shipment.
     * @param  ?\DateTimeInterface  $createdAt  Timestamp when the shipment was created. The date is returned in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> format.
     * @param  ?string  $externalReferenceId  Client-provided reference ID that can correlate this shipment to client resources. For example, to map this shipment to an internal bookkeeping order record.
     * @param  InventoryQuantity[]|null  $receivedQuantity  Quantity received (at the receiving end) as part of this shipment.
     * @param  ?\DateTimeInterface  $shipBy  Timestamp when the shipment will be shipped.
     * @param  ?string  $trackingId  Carrier-unique tracking ID for this shipment.
     * @param  ?\DateTimeInterface  $updatedAt  Timestamp when the shipment was updated. The date is returned in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> format.
     * @param  ?string  $warehouseReferenceId  An AWD-provided reference ID that you can use to interact with the warehouse. For example, a carrier appointment booking.
     */
    public function __construct(
        public readonly Address $destinationAddress,
        public readonly string $orderId,
        public readonly Address $originAddress,
        public readonly array $shipmentContainerQuantities,
        public readonly string $shipmentId,
        public readonly string $shipmentStatus,
        public readonly ?CarrierCode $carrierCode = null,
        public readonly ?\DateTimeInterface $createdAt = null,
        public readonly ?string $externalReferenceId = null,
        public readonly ?array $receivedQuantity = null,
        public readonly ?\DateTimeInterface $shipBy = null,
        public readonly ?string $trackingId = null,
        public readonly ?\DateTimeInterface $updatedAt = null,
        public readonly ?string $warehouseReferenceId = null,
    ) {}
}
