<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\RequestGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\DataKioskV20231115\Requests;

use Exception;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\DataKioskV20231115\Dto\CreateQuerySpecification;
use SellingPartnerApi\Seller\DataKioskV20231115\Responses\CreateQueryResponse;
use SellingPartnerApi\Seller\DataKioskV20231115\Responses\ErrorList;

/**
 * createQuery
 */
class CreateQuery extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * @param  CreateQuerySpecification  $createQuerySpecification  Information required to create the query.
     */
    public function __construct(
        public CreateQuerySpecification $createQuerySpecification,
    ) {}

    public function resolveEndpoint(): string
    {
        return '/dataKiosk/2023-11-15/queries';
    }

    public function createDtoFromResponse(Response $response): CreateQueryResponse|ErrorList
    {
        $status = $response->status();
        $responseCls = match ($status) {
            202 => CreateQueryResponse::class,
            400, 403, 404, 413, 415, 429, 500, 503 => ErrorList::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        return $responseCls::deserialize($response->json());
    }

    public function defaultBody(): array
    {
        return $this->createQuerySpecification->toArray();
    }
}
