<?php
/**
 * TransportShipmentMeasurements
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * TransportShipmentMeasurements Class Doc Comment
 *
 * @category Class
 * @description Shipment measurement details.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class TransportShipmentMeasurements extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransportShipmentMeasurements';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'total_carton_count' => 'int',
        'total_pallet_stackable' => 'int',
        'total_pallet_non_stackable' => 'int',
        'shipment_weight' => '\SellingPartnerApi\Model\VendorShippingV1\Weight',
        'shipment_volume' => '\SellingPartnerApi\Model\VendorShippingV1\Volume'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'total_carton_count' => null,
        'total_pallet_stackable' => null,
        'total_pallet_non_stackable' => null,
        'shipment_weight' => null,
        'shipment_volume' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'total_carton_count' => 'totalCartonCount',
        'total_pallet_stackable' => 'totalPalletStackable',
        'total_pallet_non_stackable' => 'totalPalletNonStackable',
        'shipment_weight' => 'shipmentWeight',
        'shipment_volume' => 'shipmentVolume'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'total_carton_count' => 'setTotalCartonCount',
        'total_pallet_stackable' => 'setTotalPalletStackable',
        'total_pallet_non_stackable' => 'setTotalPalletNonStackable',
        'shipment_weight' => 'setShipmentWeight',
        'shipment_volume' => 'setShipmentVolume'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'total_carton_count' => 'getTotalCartonCount',
        'total_pallet_stackable' => 'getTotalPalletStackable',
        'total_pallet_non_stackable' => 'getTotalPalletNonStackable',
        'shipment_weight' => 'getShipmentWeight',
        'shipment_volume' => 'getShipmentVolume'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['total_carton_count'] = $data['total_carton_count'] ?? null;
        $this->container['total_pallet_stackable'] = $data['total_pallet_stackable'] ?? null;
        $this->container['total_pallet_non_stackable'] = $data['total_pallet_non_stackable'] ?? null;
        $this->container['shipment_weight'] = $data['shipment_weight'] ?? null;
        $this->container['shipment_volume'] = $data['shipment_volume'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets total_carton_count
     *
     * @return int|null
     */
    public function getTotalCartonCount()
    {
        return $this->container['total_carton_count'];
    }

    /**
     * Sets total_carton_count
     *
     * @param int|null $total_carton_count Total number of cartons present in the shipment. Provide the cartonCount only for non-palletized shipments.
     *
     * @return self
     */
    public function setTotalCartonCount($total_carton_count)
    {
        $this->container['total_carton_count'] = $total_carton_count;

        return $this;
    }
    /**
     * Gets total_pallet_stackable
     *
     * @return int|null
     */
    public function getTotalPalletStackable()
    {
        return $this->container['total_pallet_stackable'];
    }

    /**
     * Sets total_pallet_stackable
     *
     * @param int|null $total_pallet_stackable Total number of Stackable Pallets present in the shipment.
     *
     * @return self
     */
    public function setTotalPalletStackable($total_pallet_stackable)
    {
        $this->container['total_pallet_stackable'] = $total_pallet_stackable;

        return $this;
    }
    /**
     * Gets total_pallet_non_stackable
     *
     * @return int|null
     */
    public function getTotalPalletNonStackable()
    {
        return $this->container['total_pallet_non_stackable'];
    }

    /**
     * Sets total_pallet_non_stackable
     *
     * @param int|null $total_pallet_non_stackable Total number of Non Stackable Pallets present in the shipment.
     *
     * @return self
     */
    public function setTotalPalletNonStackable($total_pallet_non_stackable)
    {
        $this->container['total_pallet_non_stackable'] = $total_pallet_non_stackable;

        return $this;
    }
    /**
     * Gets shipment_weight
     *
     * @return \SellingPartnerApi\Model\VendorShippingV1\Weight|null
     */
    public function getShipmentWeight()
    {
        return $this->container['shipment_weight'];
    }

    /**
     * Sets shipment_weight
     *
     * @param \SellingPartnerApi\Model\VendorShippingV1\Weight|null $shipment_weight shipment_weight
     *
     * @return self
     */
    public function setShipmentWeight($shipment_weight)
    {
        $this->container['shipment_weight'] = $shipment_weight;

        return $this;
    }
    /**
     * Gets shipment_volume
     *
     * @return \SellingPartnerApi\Model\VendorShippingV1\Volume|null
     */
    public function getShipmentVolume()
    {
        return $this->container['shipment_volume'];
    }

    /**
     * Sets shipment_volume
     *
     * @param \SellingPartnerApi\Model\VendorShippingV1\Volume|null $shipment_volume shipment_volume
     *
     * @return self
     */
    public function setShipmentVolume($shipment_volume)
    {
        $this->container['shipment_volume'] = $shipment_volume;

        return $this;
    }
}


