<?php
/**
 * Expiry
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * Expiry Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Expiry extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Expiry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'manufacturer_date' => 'string',
        'expiry_date' => 'string',
        'expiry_after_duration' => '\SellingPartnerApi\Model\VendorShippingV1\Duration'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'manufacturer_date' => null,
        'expiry_date' => null,
        'expiry_after_duration' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'manufacturer_date' => 'manufacturerDate',
        'expiry_date' => 'expiryDate',
        'expiry_after_duration' => 'expiryAfterDuration'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'manufacturer_date' => 'setManufacturerDate',
        'expiry_date' => 'setExpiryDate',
        'expiry_after_duration' => 'setExpiryAfterDuration'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'manufacturer_date' => 'getManufacturerDate',
        'expiry_date' => 'getExpiryDate',
        'expiry_after_duration' => 'getExpiryAfterDuration'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['manufacturer_date'] = $data['manufacturer_date'] ?? null;
        $this->container['expiry_date'] = $data['expiry_date'] ?? null;
        $this->container['expiry_after_duration'] = $data['expiry_after_duration'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets manufacturer_date
     *
     * @return string|null
     */
    public function getManufacturerDate()
    {
        return $this->container['manufacturer_date'];
    }

    /**
     * Sets manufacturer_date
     *
     * @param string|null $manufacturer_date Production, packaging or assembly date determined by the manufacturer. Its meaning is determined based on the trade item context.
     *
     * @return self
     */
    public function setManufacturerDate($manufacturer_date)
    {
        $this->container['manufacturer_date'] = $manufacturer_date;

        return $this;
    }
    /**
     * Gets expiry_date
     *
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->container['expiry_date'];
    }

    /**
     * Sets expiry_date
     *
     * @param string|null $expiry_date The date that determines the limit of consumption or use of a product. Its meaning is determined based on the trade item context.
     *
     * @return self
     */
    public function setExpiryDate($expiry_date)
    {
        $this->container['expiry_date'] = $expiry_date;

        return $this;
    }
    /**
     * Gets expiry_after_duration
     *
     * @return \SellingPartnerApi\Model\VendorShippingV1\Duration|null
     */
    public function getExpiryAfterDuration()
    {
        return $this->container['expiry_after_duration'];
    }

    /**
     * Sets expiry_after_duration
     *
     * @param \SellingPartnerApi\Model\VendorShippingV1\Duration|null $expiry_after_duration expiry_after_duration
     *
     * @return self
     */
    public function setExpiryAfterDuration($expiry_after_duration)
    {
        $this->container['expiry_after_duration'] = $expiry_after_duration;

        return $this;
    }
}


