<?php
/**
 * Granularity
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for FBA Inventory
 *
 * The Selling Partner API for FBA Inventory lets you programmatically retrieve information about inventory in Amazon's fulfillment network.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FbaInventoryV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * Granularity Class Doc Comment
 *
 * @category Class
 * @description Describes a granularity at which inventory data can be aggregated. For example, if you use Marketplace granularity, the fulfillable quantity will reflect inventory that could be fulfilled in the given marketplace.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Granularity extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Granularity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'granularity_type' => 'string',
        'granularity_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'granularity_type' => null,
        'granularity_id' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'granularity_type' => 'granularityType',
        'granularity_id' => 'granularityId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'granularity_type' => 'setGranularityType',
        'granularity_id' => 'setGranularityId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'granularity_type' => 'getGranularityType',
        'granularity_id' => 'getGranularityId'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['granularity_type'] = $data['granularity_type'] ?? null;
        $this->container['granularity_id'] = $data['granularity_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets granularity_type
     *
     * @return string|null
     */
    public function getGranularityType()
    {
        return $this->container['granularity_type'];
    }

    /**
     * Sets granularity_type
     *
     * @param string|null $granularity_type The granularity type for the inventory aggregation level.
     *
     * @return self
     */
    public function setGranularityType($granularity_type)
    {
        $this->container['granularity_type'] = $granularity_type;

        return $this;
    }
    /**
     * Gets granularity_id
     *
     * @return string|null
     */
    public function getGranularityId()
    {
        return $this->container['granularity_id'];
    }

    /**
     * Sets granularity_id
     *
     * @param string|null $granularity_id The granularity ID for the specified granularity type. When granularityType is Marketplace, specify the marketplaceId.
     *
     * @return self
     */
    public function setGranularityId($granularity_id)
    {
        $this->container['granularity_id'] = $granularity_id;

        return $this;
    }
}


