<?php

/**
 * This file is auto-generated by Saloon SDK Generator
 * Generator: SellingPartnerApi\Generator\Generators\RequestGenerator
 * Do not modify it directly.
 */

declare(strict_types=1);

namespace SellingPartnerApi\Seller\FBAInventoryV1\Requests;

use Exception;
use Saloon\Enums\Method;
use Saloon\Http\Response;
use SellingPartnerApi\Request;
use SellingPartnerApi\Seller\FBAInventoryV1\Responses\DeleteInventoryItemResponse;

/**
 * deleteInventoryItem
 */
class DeleteInventoryItem extends Request
{
    protected Method $method = Method::DELETE;

    /**
     * @param  string  $sellerSku  A single seller SKU used for querying the specified seller SKU inventory summaries.
     * @param  string  $marketplaceId  The marketplace ID for the marketplace for which the sellerSku is to be deleted.
     */
    public function __construct(
        protected string $sellerSku,
        protected string $marketplaceId,
    ) {}

    public function resolveEndpoint(): string
    {
        return "/fba/inventory/v1/items/{$this->sellerSku}";
    }

    public function createDtoFromResponse(Response $response): DeleteInventoryItemResponse
    {
        $status = $response->status();
        $responseCls = match ($status) {
            200, 400, 403, 404, 429, 500, 503 => DeleteInventoryItemResponse::class,
            default => throw new Exception("Unhandled response status: {$status}")
        };

        return $responseCls::deserialize($response->json(), $responseCls);
    }

    public function defaultQuery(): array
    {
        return array_filter(['marketplaceId' => $this->marketplaceId]);
    }
}
