<?php
/**
 * FinancialEvents
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Finances
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\Finances;

use \ArrayAccess;
use \SellingPartnerApi\ObjectSerializer;
use \SellingPartnerApi\Model\ModelInterface;

/**
 * FinancialEvents Class Doc Comment
 *
 * @category Class
 * @description Contains all information related to a financial event.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class FinancialEvents implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FinancialEvents';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shipment_event_list' => '\SellingPartnerApi\Model\Finances\ShipmentEvent[]',
        'refund_event_list' => '\SellingPartnerApi\Model\Finances\ShipmentEvent[]',
        'guarantee_claim_event_list' => '\SellingPartnerApi\Model\Finances\ShipmentEvent[]',
        'chargeback_event_list' => '\SellingPartnerApi\Model\Finances\ShipmentEvent[]',
        'pay_with_amazon_event_list' => '\SellingPartnerApi\Model\Finances\PayWithAmazonEvent[]',
        'service_provider_credit_event_list' => '\SellingPartnerApi\Model\Finances\SolutionProviderCreditEvent[]',
        'retrocharge_event_list' => '\SellingPartnerApi\Model\Finances\RetrochargeEvent[]',
        'rental_transaction_event_list' => '\SellingPartnerApi\Model\Finances\RentalTransactionEvent[]',
        'product_ads_payment_event_list' => '\SellingPartnerApi\Model\Finances\ProductAdsPaymentEvent[]',
        'service_fee_event_list' => '\SellingPartnerApi\Model\Finances\ServiceFeeEvent[]',
        'seller_deal_payment_event_list' => '\SellingPartnerApi\Model\Finances\SellerDealPaymentEvent[]',
        'debt_recovery_event_list' => '\SellingPartnerApi\Model\Finances\DebtRecoveryEvent[]',
        'loan_servicing_event_list' => '\SellingPartnerApi\Model\Finances\LoanServicingEvent[]',
        'adjustment_event_list' => '\SellingPartnerApi\Model\Finances\AdjustmentEvent[]',
        'safet_reimbursement_event_list' => '\SellingPartnerApi\Model\Finances\SAFETReimbursementEvent[]',
        'seller_review_enrollment_payment_event_list' => '\SellingPartnerApi\Model\Finances\SellerReviewEnrollmentPaymentEvent[]',
        'fba_liquidation_event_list' => '\SellingPartnerApi\Model\Finances\FBALiquidationEvent[]',
        'coupon_payment_event_list' => '\SellingPartnerApi\Model\Finances\CouponPaymentEvent[]',
        'imaging_services_fee_event_list' => '\SellingPartnerApi\Model\Finances\ImagingServicesFeeEvent[]',
        'network_commingling_transaction_event_list' => '\SellingPartnerApi\Model\Finances\NetworkComminglingTransactionEvent[]',
        'affordability_expense_event_list' => '\SellingPartnerApi\Model\Finances\AffordabilityExpenseEvent[]',
        'affordability_expense_reversal_event_list' => '\SellingPartnerApi\Model\Finances\AffordabilityExpenseEvent[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shipment_event_list' => null,
        'refund_event_list' => null,
        'guarantee_claim_event_list' => null,
        'chargeback_event_list' => null,
        'pay_with_amazon_event_list' => null,
        'service_provider_credit_event_list' => null,
        'retrocharge_event_list' => null,
        'rental_transaction_event_list' => null,
        'product_ads_payment_event_list' => null,
        'service_fee_event_list' => null,
        'seller_deal_payment_event_list' => null,
        'debt_recovery_event_list' => null,
        'loan_servicing_event_list' => null,
        'adjustment_event_list' => null,
        'safet_reimbursement_event_list' => null,
        'seller_review_enrollment_payment_event_list' => null,
        'fba_liquidation_event_list' => null,
        'coupon_payment_event_list' => null,
        'imaging_services_fee_event_list' => null,
        'network_commingling_transaction_event_list' => null,
        'affordability_expense_event_list' => null,
        'affordability_expense_reversal_event_list' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipment_event_list' => 'ShipmentEventList',
        'refund_event_list' => 'RefundEventList',
        'guarantee_claim_event_list' => 'GuaranteeClaimEventList',
        'chargeback_event_list' => 'ChargebackEventList',
        'pay_with_amazon_event_list' => 'PayWithAmazonEventList',
        'service_provider_credit_event_list' => 'ServiceProviderCreditEventList',
        'retrocharge_event_list' => 'RetrochargeEventList',
        'rental_transaction_event_list' => 'RentalTransactionEventList',
        'product_ads_payment_event_list' => 'ProductAdsPaymentEventList',
        'service_fee_event_list' => 'ServiceFeeEventList',
        'seller_deal_payment_event_list' => 'SellerDealPaymentEventList',
        'debt_recovery_event_list' => 'DebtRecoveryEventList',
        'loan_servicing_event_list' => 'LoanServicingEventList',
        'adjustment_event_list' => 'AdjustmentEventList',
        'safet_reimbursement_event_list' => 'SAFETReimbursementEventList',
        'seller_review_enrollment_payment_event_list' => 'SellerReviewEnrollmentPaymentEventList',
        'fba_liquidation_event_list' => 'FBALiquidationEventList',
        'coupon_payment_event_list' => 'CouponPaymentEventList',
        'imaging_services_fee_event_list' => 'ImagingServicesFeeEventList',
        'network_commingling_transaction_event_list' => 'NetworkComminglingTransactionEventList',
        'affordability_expense_event_list' => 'AffordabilityExpenseEventList',
        'affordability_expense_reversal_event_list' => 'AffordabilityExpenseReversalEventList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipment_event_list' => 'setShipmentEventList',
        'refund_event_list' => 'setRefundEventList',
        'guarantee_claim_event_list' => 'setGuaranteeClaimEventList',
        'chargeback_event_list' => 'setChargebackEventList',
        'pay_with_amazon_event_list' => 'setPayWithAmazonEventList',
        'service_provider_credit_event_list' => 'setServiceProviderCreditEventList',
        'retrocharge_event_list' => 'setRetrochargeEventList',
        'rental_transaction_event_list' => 'setRentalTransactionEventList',
        'product_ads_payment_event_list' => 'setProductAdsPaymentEventList',
        'service_fee_event_list' => 'setServiceFeeEventList',
        'seller_deal_payment_event_list' => 'setSellerDealPaymentEventList',
        'debt_recovery_event_list' => 'setDebtRecoveryEventList',
        'loan_servicing_event_list' => 'setLoanServicingEventList',
        'adjustment_event_list' => 'setAdjustmentEventList',
        'safet_reimbursement_event_list' => 'setSafetReimbursementEventList',
        'seller_review_enrollment_payment_event_list' => 'setSellerReviewEnrollmentPaymentEventList',
        'fba_liquidation_event_list' => 'setFbaLiquidationEventList',
        'coupon_payment_event_list' => 'setCouponPaymentEventList',
        'imaging_services_fee_event_list' => 'setImagingServicesFeeEventList',
        'network_commingling_transaction_event_list' => 'setNetworkComminglingTransactionEventList',
        'affordability_expense_event_list' => 'setAffordabilityExpenseEventList',
        'affordability_expense_reversal_event_list' => 'setAffordabilityExpenseReversalEventList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipment_event_list' => 'getShipmentEventList',
        'refund_event_list' => 'getRefundEventList',
        'guarantee_claim_event_list' => 'getGuaranteeClaimEventList',
        'chargeback_event_list' => 'getChargebackEventList',
        'pay_with_amazon_event_list' => 'getPayWithAmazonEventList',
        'service_provider_credit_event_list' => 'getServiceProviderCreditEventList',
        'retrocharge_event_list' => 'getRetrochargeEventList',
        'rental_transaction_event_list' => 'getRentalTransactionEventList',
        'product_ads_payment_event_list' => 'getProductAdsPaymentEventList',
        'service_fee_event_list' => 'getServiceFeeEventList',
        'seller_deal_payment_event_list' => 'getSellerDealPaymentEventList',
        'debt_recovery_event_list' => 'getDebtRecoveryEventList',
        'loan_servicing_event_list' => 'getLoanServicingEventList',
        'adjustment_event_list' => 'getAdjustmentEventList',
        'safet_reimbursement_event_list' => 'getSafetReimbursementEventList',
        'seller_review_enrollment_payment_event_list' => 'getSellerReviewEnrollmentPaymentEventList',
        'fba_liquidation_event_list' => 'getFbaLiquidationEventList',
        'coupon_payment_event_list' => 'getCouponPaymentEventList',
        'imaging_services_fee_event_list' => 'getImagingServicesFeeEventList',
        'network_commingling_transaction_event_list' => 'getNetworkComminglingTransactionEventList',
        'affordability_expense_event_list' => 'getAffordabilityExpenseEventList',
        'affordability_expense_reversal_event_list' => 'getAffordabilityExpenseReversalEventList'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shipment_event_list'] = $data['shipment_event_list'] ?? null;
        $this->container['refund_event_list'] = $data['refund_event_list'] ?? null;
        $this->container['guarantee_claim_event_list'] = $data['guarantee_claim_event_list'] ?? null;
        $this->container['chargeback_event_list'] = $data['chargeback_event_list'] ?? null;
        $this->container['pay_with_amazon_event_list'] = $data['pay_with_amazon_event_list'] ?? null;
        $this->container['service_provider_credit_event_list'] = $data['service_provider_credit_event_list'] ?? null;
        $this->container['retrocharge_event_list'] = $data['retrocharge_event_list'] ?? null;
        $this->container['rental_transaction_event_list'] = $data['rental_transaction_event_list'] ?? null;
        $this->container['product_ads_payment_event_list'] = $data['product_ads_payment_event_list'] ?? null;
        $this->container['service_fee_event_list'] = $data['service_fee_event_list'] ?? null;
        $this->container['seller_deal_payment_event_list'] = $data['seller_deal_payment_event_list'] ?? null;
        $this->container['debt_recovery_event_list'] = $data['debt_recovery_event_list'] ?? null;
        $this->container['loan_servicing_event_list'] = $data['loan_servicing_event_list'] ?? null;
        $this->container['adjustment_event_list'] = $data['adjustment_event_list'] ?? null;
        $this->container['safet_reimbursement_event_list'] = $data['safet_reimbursement_event_list'] ?? null;
        $this->container['seller_review_enrollment_payment_event_list'] = $data['seller_review_enrollment_payment_event_list'] ?? null;
        $this->container['fba_liquidation_event_list'] = $data['fba_liquidation_event_list'] ?? null;
        $this->container['coupon_payment_event_list'] = $data['coupon_payment_event_list'] ?? null;
        $this->container['imaging_services_fee_event_list'] = $data['imaging_services_fee_event_list'] ?? null;
        $this->container['network_commingling_transaction_event_list'] = $data['network_commingling_transaction_event_list'] ?? null;
        $this->container['affordability_expense_event_list'] = $data['affordability_expense_event_list'] ?? null;
        $this->container['affordability_expense_reversal_event_list'] = $data['affordability_expense_reversal_event_list'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shipment_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null
     */
    public function getShipmentEventList()
    {
        return $this->container['shipment_event_list'];
    }

    /**
     * Sets shipment_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null $shipment_event_list A list of shipment event information.
     *
     * @return self
     */
    public function setShipmentEventList($shipment_event_list)
    {
        $this->container['shipment_event_list'] = $shipment_event_list;

        return $this;
    }

    /**
     * Gets refund_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null
     */
    public function getRefundEventList()
    {
        return $this->container['refund_event_list'];
    }

    /**
     * Sets refund_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null $refund_event_list A list of shipment event information.
     *
     * @return self
     */
    public function setRefundEventList($refund_event_list)
    {
        $this->container['refund_event_list'] = $refund_event_list;

        return $this;
    }

    /**
     * Gets guarantee_claim_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null
     */
    public function getGuaranteeClaimEventList()
    {
        return $this->container['guarantee_claim_event_list'];
    }

    /**
     * Sets guarantee_claim_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null $guarantee_claim_event_list A list of shipment event information.
     *
     * @return self
     */
    public function setGuaranteeClaimEventList($guarantee_claim_event_list)
    {
        $this->container['guarantee_claim_event_list'] = $guarantee_claim_event_list;

        return $this;
    }

    /**
     * Gets chargeback_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null
     */
    public function getChargebackEventList()
    {
        return $this->container['chargeback_event_list'];
    }

    /**
     * Sets chargeback_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\ShipmentEvent[]|null $chargeback_event_list A list of shipment event information.
     *
     * @return self
     */
    public function setChargebackEventList($chargeback_event_list)
    {
        $this->container['chargeback_event_list'] = $chargeback_event_list;

        return $this;
    }

    /**
     * Gets pay_with_amazon_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\PayWithAmazonEvent[]|null
     */
    public function getPayWithAmazonEventList()
    {
        return $this->container['pay_with_amazon_event_list'];
    }

    /**
     * Sets pay_with_amazon_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\PayWithAmazonEvent[]|null $pay_with_amazon_event_list A list of events related to the seller's Pay with Amazon account.
     *
     * @return self
     */
    public function setPayWithAmazonEventList($pay_with_amazon_event_list)
    {
        $this->container['pay_with_amazon_event_list'] = $pay_with_amazon_event_list;

        return $this;
    }

    /**
     * Gets service_provider_credit_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\SolutionProviderCreditEvent[]|null
     */
    public function getServiceProviderCreditEventList()
    {
        return $this->container['service_provider_credit_event_list'];
    }

    /**
     * Sets service_provider_credit_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\SolutionProviderCreditEvent[]|null $service_provider_credit_event_list A list of information about solution provider credits.
     *
     * @return self
     */
    public function setServiceProviderCreditEventList($service_provider_credit_event_list)
    {
        $this->container['service_provider_credit_event_list'] = $service_provider_credit_event_list;

        return $this;
    }

    /**
     * Gets retrocharge_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\RetrochargeEvent[]|null
     */
    public function getRetrochargeEventList()
    {
        return $this->container['retrocharge_event_list'];
    }

    /**
     * Sets retrocharge_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\RetrochargeEvent[]|null $retrocharge_event_list A list of information about Retrocharge or RetrochargeReversal events.
     *
     * @return self
     */
    public function setRetrochargeEventList($retrocharge_event_list)
    {
        $this->container['retrocharge_event_list'] = $retrocharge_event_list;

        return $this;
    }

    /**
     * Gets rental_transaction_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\RentalTransactionEvent[]|null
     */
    public function getRentalTransactionEventList()
    {
        return $this->container['rental_transaction_event_list'];
    }

    /**
     * Sets rental_transaction_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\RentalTransactionEvent[]|null $rental_transaction_event_list A list of rental transaction event information.
     *
     * @return self
     */
    public function setRentalTransactionEventList($rental_transaction_event_list)
    {
        $this->container['rental_transaction_event_list'] = $rental_transaction_event_list;

        return $this;
    }

    /**
     * Gets product_ads_payment_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\ProductAdsPaymentEvent[]|null
     */
    public function getProductAdsPaymentEventList()
    {
        return $this->container['product_ads_payment_event_list'];
    }

    /**
     * Sets product_ads_payment_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\ProductAdsPaymentEvent[]|null $product_ads_payment_event_list A list of sponsored products payment events.
     *
     * @return self
     */
    public function setProductAdsPaymentEventList($product_ads_payment_event_list)
    {
        $this->container['product_ads_payment_event_list'] = $product_ads_payment_event_list;

        return $this;
    }

    /**
     * Gets service_fee_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\ServiceFeeEvent[]|null
     */
    public function getServiceFeeEventList()
    {
        return $this->container['service_fee_event_list'];
    }

    /**
     * Sets service_fee_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\ServiceFeeEvent[]|null $service_fee_event_list A list of information about service fee events.
     *
     * @return self
     */
    public function setServiceFeeEventList($service_fee_event_list)
    {
        $this->container['service_fee_event_list'] = $service_fee_event_list;

        return $this;
    }

    /**
     * Gets seller_deal_payment_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\SellerDealPaymentEvent[]|null
     */
    public function getSellerDealPaymentEventList()
    {
        return $this->container['seller_deal_payment_event_list'];
    }

    /**
     * Sets seller_deal_payment_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\SellerDealPaymentEvent[]|null $seller_deal_payment_event_list A list of payment events for deal-related fees.
     *
     * @return self
     */
    public function setSellerDealPaymentEventList($seller_deal_payment_event_list)
    {
        $this->container['seller_deal_payment_event_list'] = $seller_deal_payment_event_list;

        return $this;
    }

    /**
     * Gets debt_recovery_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\DebtRecoveryEvent[]|null
     */
    public function getDebtRecoveryEventList()
    {
        return $this->container['debt_recovery_event_list'];
    }

    /**
     * Sets debt_recovery_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\DebtRecoveryEvent[]|null $debt_recovery_event_list A list of debt recovery event information.
     *
     * @return self
     */
    public function setDebtRecoveryEventList($debt_recovery_event_list)
    {
        $this->container['debt_recovery_event_list'] = $debt_recovery_event_list;

        return $this;
    }

    /**
     * Gets loan_servicing_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\LoanServicingEvent[]|null
     */
    public function getLoanServicingEventList()
    {
        return $this->container['loan_servicing_event_list'];
    }

    /**
     * Sets loan_servicing_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\LoanServicingEvent[]|null $loan_servicing_event_list A list of loan servicing events.
     *
     * @return self
     */
    public function setLoanServicingEventList($loan_servicing_event_list)
    {
        $this->container['loan_servicing_event_list'] = $loan_servicing_event_list;

        return $this;
    }

    /**
     * Gets adjustment_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\AdjustmentEvent[]|null
     */
    public function getAdjustmentEventList()
    {
        return $this->container['adjustment_event_list'];
    }

    /**
     * Sets adjustment_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\AdjustmentEvent[]|null $adjustment_event_list A list of adjustment event information for the seller's account.
     *
     * @return self
     */
    public function setAdjustmentEventList($adjustment_event_list)
    {
        $this->container['adjustment_event_list'] = $adjustment_event_list;

        return $this;
    }

    /**
     * Gets safet_reimbursement_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\SAFETReimbursementEvent[]|null
     */
    public function getSafetReimbursementEventList()
    {
        return $this->container['safet_reimbursement_event_list'];
    }

    /**
     * Sets safet_reimbursement_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\SAFETReimbursementEvent[]|null $safet_reimbursement_event_list A list of SAFETReimbursementEvents.
     *
     * @return self
     */
    public function setSafetReimbursementEventList($safet_reimbursement_event_list)
    {
        $this->container['safet_reimbursement_event_list'] = $safet_reimbursement_event_list;

        return $this;
    }

    /**
     * Gets seller_review_enrollment_payment_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\SellerReviewEnrollmentPaymentEvent[]|null
     */
    public function getSellerReviewEnrollmentPaymentEventList()
    {
        return $this->container['seller_review_enrollment_payment_event_list'];
    }

    /**
     * Sets seller_review_enrollment_payment_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\SellerReviewEnrollmentPaymentEvent[]|null $seller_review_enrollment_payment_event_list A list of information about fee events for the Early Reviewer Program.
     *
     * @return self
     */
    public function setSellerReviewEnrollmentPaymentEventList($seller_review_enrollment_payment_event_list)
    {
        $this->container['seller_review_enrollment_payment_event_list'] = $seller_review_enrollment_payment_event_list;

        return $this;
    }

    /**
     * Gets fba_liquidation_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\FBALiquidationEvent[]|null
     */
    public function getFbaLiquidationEventList()
    {
        return $this->container['fba_liquidation_event_list'];
    }

    /**
     * Sets fba_liquidation_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\FBALiquidationEvent[]|null $fba_liquidation_event_list A list of FBA inventory liquidation payment events.
     *
     * @return self
     */
    public function setFbaLiquidationEventList($fba_liquidation_event_list)
    {
        $this->container['fba_liquidation_event_list'] = $fba_liquidation_event_list;

        return $this;
    }

    /**
     * Gets coupon_payment_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\CouponPaymentEvent[]|null
     */
    public function getCouponPaymentEventList()
    {
        return $this->container['coupon_payment_event_list'];
    }

    /**
     * Sets coupon_payment_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\CouponPaymentEvent[]|null $coupon_payment_event_list A list of coupon payment event information.
     *
     * @return self
     */
    public function setCouponPaymentEventList($coupon_payment_event_list)
    {
        $this->container['coupon_payment_event_list'] = $coupon_payment_event_list;

        return $this;
    }

    /**
     * Gets imaging_services_fee_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\ImagingServicesFeeEvent[]|null
     */
    public function getImagingServicesFeeEventList()
    {
        return $this->container['imaging_services_fee_event_list'];
    }

    /**
     * Sets imaging_services_fee_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\ImagingServicesFeeEvent[]|null $imaging_services_fee_event_list A list of fee events related to Amazon Imaging services.
     *
     * @return self
     */
    public function setImagingServicesFeeEventList($imaging_services_fee_event_list)
    {
        $this->container['imaging_services_fee_event_list'] = $imaging_services_fee_event_list;

        return $this;
    }

    /**
     * Gets network_commingling_transaction_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\NetworkComminglingTransactionEvent[]|null
     */
    public function getNetworkComminglingTransactionEventList()
    {
        return $this->container['network_commingling_transaction_event_list'];
    }

    /**
     * Sets network_commingling_transaction_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\NetworkComminglingTransactionEvent[]|null $network_commingling_transaction_event_list A list of network commingling transaction events.
     *
     * @return self
     */
    public function setNetworkComminglingTransactionEventList($network_commingling_transaction_event_list)
    {
        $this->container['network_commingling_transaction_event_list'] = $network_commingling_transaction_event_list;

        return $this;
    }

    /**
     * Gets affordability_expense_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\AffordabilityExpenseEvent[]|null
     */
    public function getAffordabilityExpenseEventList()
    {
        return $this->container['affordability_expense_event_list'];
    }

    /**
     * Sets affordability_expense_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\AffordabilityExpenseEvent[]|null $affordability_expense_event_list A list of expense information related to an affordability promotion.
     *
     * @return self
     */
    public function setAffordabilityExpenseEventList($affordability_expense_event_list)
    {
        $this->container['affordability_expense_event_list'] = $affordability_expense_event_list;

        return $this;
    }

    /**
     * Gets affordability_expense_reversal_event_list
     *
     * @return \SellingPartnerApi\Model\Finances\AffordabilityExpenseEvent[]|null
     */
    public function getAffordabilityExpenseReversalEventList()
    {
        return $this->container['affordability_expense_reversal_event_list'];
    }

    /**
     * Sets affordability_expense_reversal_event_list
     *
     * @param \SellingPartnerApi\Model\Finances\AffordabilityExpenseEvent[]|null $affordability_expense_reversal_event_list A list of expense information related to an affordability promotion.
     *
     * @return self
     */
    public function setAffordabilityExpenseReversalEventList($affordability_expense_reversal_event_list)
    {
        $this->container['affordability_expense_reversal_event_list'] = $affordability_expense_reversal_event_list;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


