<?php
/**
 * IneligibleRate
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Amazon Shipping API
 *
 * The Amazon Shipping API is designed to support outbound shipping use cases both for orders originating on Amazon-owned marketplaces as well as external channels/marketplaces. With these APIs, you can request shipping rates, create shipments, cancel shipments, and track shipments.
 *
 * The version of the OpenAPI document: v2
 * Contact: swa-api-core@amazon.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ShippingV2;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * IneligibleRate Class Doc Comment
 *
 * @category Class
 * @description Detailed information for an ineligible shipping service offering.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class IneligibleRate extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'IneligibleRate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'service_id' => 'string',
        'service_name' => 'string',
        'carrier_name' => 'string',
        'carrier_id' => 'string',
        'ineligibility_reasons' => '\SellingPartnerApi\Model\ShippingV2\IneligibilityReason[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'service_id' => null,
        'service_name' => null,
        'carrier_name' => null,
        'carrier_id' => null,
        'ineligibility_reasons' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'service_id' => 'serviceId',
        'service_name' => 'serviceName',
        'carrier_name' => 'carrierName',
        'carrier_id' => 'carrierId',
        'ineligibility_reasons' => 'ineligibilityReasons'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'service_id' => 'setServiceId',
        'service_name' => 'setServiceName',
        'carrier_name' => 'setCarrierName',
        'carrier_id' => 'setCarrierId',
        'ineligibility_reasons' => 'setIneligibilityReasons'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'service_id' => 'getServiceId',
        'service_name' => 'getServiceName',
        'carrier_name' => 'getCarrierName',
        'carrier_id' => 'getCarrierId',
        'ineligibility_reasons' => 'getIneligibilityReasons'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['service_id'] = $data['service_id'] ?? null;
        $this->container['service_name'] = $data['service_name'] ?? null;
        $this->container['carrier_name'] = $data['carrier_name'] ?? null;
        $this->container['carrier_id'] = $data['carrier_id'] ?? null;
        $this->container['ineligibility_reasons'] = $data['ineligibility_reasons'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['service_id'] === null) {
            $invalidProperties[] = "'service_id' can't be null";
        }
        if ($this->container['service_name'] === null) {
            $invalidProperties[] = "'service_name' can't be null";
        }
        if ($this->container['carrier_name'] === null) {
            $invalidProperties[] = "'carrier_name' can't be null";
        }
        if ($this->container['carrier_id'] === null) {
            $invalidProperties[] = "'carrier_id' can't be null";
        }
        if ($this->container['ineligibility_reasons'] === null) {
            $invalidProperties[] = "'ineligibility_reasons' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets service_id
     *
     * @return string
     */
    public function getServiceId()
    {
        return $this->container['service_id'];
    }

    /**
     * Sets service_id
     *
     * @param string $service_id An identifier for the shipping service.
     *
     * @return self
     */
    public function setServiceId($service_id)
    {
        $this->container['service_id'] = $service_id;

        return $this;
    }
    /**
     * Gets service_name
     *
     * @return string
     */
    public function getServiceName()
    {
        return $this->container['service_name'];
    }

    /**
     * Sets service_name
     *
     * @param string $service_name The name of the shipping service.
     *
     * @return self
     */
    public function setServiceName($service_name)
    {
        $this->container['service_name'] = $service_name;

        return $this;
    }
    /**
     * Gets carrier_name
     *
     * @return string
     */
    public function getCarrierName()
    {
        return $this->container['carrier_name'];
    }

    /**
     * Sets carrier_name
     *
     * @param string $carrier_name The carrier name for the offering.
     *
     * @return self
     */
    public function setCarrierName($carrier_name)
    {
        $this->container['carrier_name'] = $carrier_name;

        return $this;
    }
    /**
     * Gets carrier_id
     *
     * @return string
     */
    public function getCarrierId()
    {
        return $this->container['carrier_id'];
    }

    /**
     * Sets carrier_id
     *
     * @param string $carrier_id The carrier identifier for the offering, provided by the carrier.
     *
     * @return self
     */
    public function setCarrierId($carrier_id)
    {
        $this->container['carrier_id'] = $carrier_id;

        return $this;
    }
    /**
     * Gets ineligibility_reasons
     *
     * @return \SellingPartnerApi\Model\ShippingV2\IneligibilityReason[]
     */
    public function getIneligibilityReasons()
    {
        return $this->container['ineligibility_reasons'];
    }

    /**
     * Sets ineligibility_reasons
     *
     * @param \SellingPartnerApi\Model\ShippingV2\IneligibilityReason[] $ineligibility_reasons A list of reasons why a shipping service offering is ineligible.
     *
     * @return self
     */
    public function setIneligibilityReasons($ineligibility_reasons)
    {
        $this->container['ineligibility_reasons'] = $ineligibility_reasons;

        return $this;
    }
}


