<?php
/**
 * Label
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Merchant Fulfillment
 *
 * The Selling Partner API for Merchant Fulfillment helps you build applications that let sellers purchase shipping for non-Prime and Prime orders using Amazon's Buy Shipping Services.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\MerchantFulfillmentV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * Label Class Doc Comment
 *
 * @category Class
 * @description Data for creating a shipping label and dimensions for printing the label.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Label extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Label';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'custom_text_for_label' => 'string',
        'dimensions' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\LabelDimensions',
        'file_contents' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\FileContents',
        'label_format' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\LabelFormat',
        'standard_id_for_label' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\StandardIdForLabel'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'custom_text_for_label' => null,
        'dimensions' => null,
        'file_contents' => null,
        'label_format' => null,
        'standard_id_for_label' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'custom_text_for_label' => 'CustomTextForLabel',
        'dimensions' => 'Dimensions',
        'file_contents' => 'FileContents',
        'label_format' => 'LabelFormat',
        'standard_id_for_label' => 'StandardIdForLabel'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'custom_text_for_label' => 'setCustomTextForLabel',
        'dimensions' => 'setDimensions',
        'file_contents' => 'setFileContents',
        'label_format' => 'setLabelFormat',
        'standard_id_for_label' => 'setStandardIdForLabel'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'custom_text_for_label' => 'getCustomTextForLabel',
        'dimensions' => 'getDimensions',
        'file_contents' => 'getFileContents',
        'label_format' => 'getLabelFormat',
        'standard_id_for_label' => 'getStandardIdForLabel'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['custom_text_for_label'] = $data['custom_text_for_label'] ?? null;
        $this->container['dimensions'] = $data['dimensions'] ?? null;
        $this->container['file_contents'] = $data['file_contents'] ?? null;
        $this->container['label_format'] = $data['label_format'] ?? null;
        $this->container['standard_id_for_label'] = $data['standard_id_for_label'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['dimensions'] === null) {
            $invalidProperties[] = "'dimensions' can't be null";
        }
        if ($this->container['file_contents'] === null) {
            $invalidProperties[] = "'file_contents' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets custom_text_for_label
     *
     * @return string|null
     */
    public function getCustomTextForLabel()
    {
        return $this->container['custom_text_for_label'];
    }

    /**
     * Sets custom_text_for_label
     *
     * @param string|null $custom_text_for_label Custom text to print on the label. Note: Custom text is only included on labels that are in ZPL format (ZPL203). FedEx does not support CustomTextForLabel.
     *
     * @return self
     */
    public function setCustomTextForLabel($custom_text_for_label)
    {
        $this->container['custom_text_for_label'] = $custom_text_for_label;

        return $this;
    }
    /**
     * Gets dimensions
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\LabelDimensions
     */
    public function getDimensions()
    {
        return $this->container['dimensions'];
    }

    /**
     * Sets dimensions
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\LabelDimensions $dimensions dimensions
     *
     * @return self
     */
    public function setDimensions($dimensions)
    {
        $this->container['dimensions'] = $dimensions;

        return $this;
    }
    /**
     * Gets file_contents
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\FileContents
     */
    public function getFileContents()
    {
        return $this->container['file_contents'];
    }

    /**
     * Sets file_contents
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\FileContents $file_contents file_contents
     *
     * @return self
     */
    public function setFileContents($file_contents)
    {
        $this->container['file_contents'] = $file_contents;

        return $this;
    }
    /**
     * Gets label_format
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\LabelFormat|null
     */
    public function getLabelFormat()
    {
        return $this->container['label_format'];
    }

    /**
     * Sets label_format
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\LabelFormat|null $label_format label_format
     *
     * @return self
     */
    public function setLabelFormat($label_format)
    {
        $this->container['label_format'] = $label_format;

        return $this;
    }
    /**
     * Gets standard_id_for_label
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\StandardIdForLabel|null
     */
    public function getStandardIdForLabel()
    {
        return $this->container['standard_id_for_label'];
    }

    /**
     * Sets standard_id_for_label
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\StandardIdForLabel|null $standard_id_for_label standard_id_for_label
     *
     * @return self
     */
    public function setStandardIdForLabel($standard_id_for_label)
    {
        $this->container['standard_id_for_label'] = $standard_id_for_label;

        return $this;
    }
}


