<?php
/**
 * Decorator
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for A+ Content Management
 *
 * With the A+ Content API, you can build applications that help selling partners add rich marketing content to their Amazon product detail pages. A+ content helps selling partners share their brand and product story, which helps buyers make informed purchasing decisions. Selling partners assemble content by choosing from content modules and adding images and text.
 *
 * The version of the OpenAPI document: 2020-11-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\AplusContentV20201101;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * Decorator Class Doc Comment
 *
 * @category Class
 * @description A decorator applied to a content string value in order to create rich text.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Decorator extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Decorator';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'type' => '\SellingPartnerApi\Model\AplusContentV20201101\DecoratorType',
        'offset' => 'int',
        'length' => 'int',
        'depth' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'type' => null,
        'offset' => null,
        'length' => null,
        'depth' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'offset' => 'offset',
        'length' => 'length',
        'depth' => 'depth'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'type' => 'setType',
        'offset' => 'setOffset',
        'length' => 'setLength',
        'depth' => 'setDepth'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'offset' => 'getOffset',
        'length' => 'getLength',
        'depth' => 'getDepth'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = $data['type'] ?? null;
        $this->container['offset'] = $data['offset'] ?? null;
        $this->container['length'] = $data['length'] ?? null;
        $this->container['depth'] = $data['depth'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if (!is_null($this->container['offset']) && ($this->container['offset'] > 10000)) {
            $invalidProperties[] = "invalid value for 'offset', must be smaller than or equal to 10000.";
        }

        if (!is_null($this->container['offset']) && ($this->container['offset'] < 0)) {
            $invalidProperties[] = "invalid value for 'offset', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['length']) && ($this->container['length'] > 10000)) {
            $invalidProperties[] = "invalid value for 'length', must be smaller than or equal to 10000.";
        }

        if (!is_null($this->container['length']) && ($this->container['length'] < 0)) {
            $invalidProperties[] = "invalid value for 'length', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['depth']) && ($this->container['depth'] > 100)) {
            $invalidProperties[] = "invalid value for 'depth', must be smaller than or equal to 100.";
        }

        if (!is_null($this->container['depth']) && ($this->container['depth'] < 0)) {
            $invalidProperties[] = "invalid value for 'depth', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }


    /**
     * Gets type
     *
     * @return \SellingPartnerApi\Model\AplusContentV20201101\DecoratorType|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param \SellingPartnerApi\Model\AplusContentV20201101\DecoratorType|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Gets offset
     *
     * @return int|null
     */
    public function getOffset()
    {
        return $this->container['offset'];
    }

    /**
     * Sets offset
     *
     * @param int|null $offset The starting character of this decorator within the content string. Use zero for the first character.
     *
     * @return self
     */
    public function setOffset($offset)
    {

        if (!is_null($offset) && ($offset > 10000)) {
            throw new \InvalidArgumentException('invalid value for $offset when calling Decorator., must be smaller than or equal to 10000.');
        }
        if (!is_null($offset) && ($offset < 0)) {
            throw new \InvalidArgumentException('invalid value for $offset when calling Decorator., must be bigger than or equal to 0.');
        }

        $this->container['offset'] = $offset;

        return $this;
    }
    /**
     * Gets length
     *
     * @return int|null
     */
    public function getLength()
    {
        return $this->container['length'];
    }

    /**
     * Sets length
     *
     * @param int|null $length The number of content characters to alter with this decorator. Decorators such as line breaks can have zero length and fit between characters.
     *
     * @return self
     */
    public function setLength($length)
    {

        if (!is_null($length) && ($length > 10000)) {
            throw new \InvalidArgumentException('invalid value for $length when calling Decorator., must be smaller than or equal to 10000.');
        }
        if (!is_null($length) && ($length < 0)) {
            throw new \InvalidArgumentException('invalid value for $length when calling Decorator., must be bigger than or equal to 0.');
        }

        $this->container['length'] = $length;

        return $this;
    }
    /**
     * Gets depth
     *
     * @return int|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param int|null $depth The relative intensity or variation of this decorator. Decorators such as bullet-points, for example, can have multiple indentation depths.
     *
     * @return self
     */
    public function setDepth($depth)
    {

        if (!is_null($depth) && ($depth > 100)) {
            throw new \InvalidArgumentException('invalid value for $depth when calling Decorator., must be smaller than or equal to 100.');
        }
        if (!is_null($depth) && ($depth < 0)) {
            throw new \InvalidArgumentException('invalid value for $depth when calling Decorator., must be bigger than or equal to 0.');
        }

        $this->container['depth'] = $depth;

        return $this;
    }
}


