<?php
/**
 * FeaturedOfferExpectedPriceResult
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Pricing
 *
 * The Selling Partner API for Pricing helps you programmatically retrieve product pricing and offer pricing information for Amazon Marketplace products. For more information, see the [Product Pricing v2022-05-01 Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/product-pricing-api-v2022-05-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2022-05-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ProductPricingV20220501;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * FeaturedOfferExpectedPriceResult Class Doc Comment
 *
 * @category Class
 * @description The featured offer expected price result data for the requested offer.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class FeaturedOfferExpectedPriceResult extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FeaturedOfferExpectedPriceResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'featured_offer_expected_price' => '\SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOfferExpectedPrice',
        'result_status' => 'string',
        'competing_featured_offer' => '\SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOffer',
        'current_featured_offer' => '\SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOffer'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'featured_offer_expected_price' => null,
        'result_status' => null,
        'competing_featured_offer' => null,
        'current_featured_offer' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'featured_offer_expected_price' => 'featuredOfferExpectedPrice',
        'result_status' => 'resultStatus',
        'competing_featured_offer' => 'competingFeaturedOffer',
        'current_featured_offer' => 'currentFeaturedOffer'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'featured_offer_expected_price' => 'setFeaturedOfferExpectedPrice',
        'result_status' => 'setResultStatus',
        'competing_featured_offer' => 'setCompetingFeaturedOffer',
        'current_featured_offer' => 'setCurrentFeaturedOffer'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'featured_offer_expected_price' => 'getFeaturedOfferExpectedPrice',
        'result_status' => 'getResultStatus',
        'competing_featured_offer' => 'getCompetingFeaturedOffer',
        'current_featured_offer' => 'getCurrentFeaturedOffer'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['featured_offer_expected_price'] = $data['featured_offer_expected_price'] ?? null;
        $this->container['result_status'] = $data['result_status'] ?? null;
        $this->container['competing_featured_offer'] = $data['competing_featured_offer'] ?? null;
        $this->container['current_featured_offer'] = $data['current_featured_offer'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['result_status'] === null) {
            $invalidProperties[] = "'result_status' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets featured_offer_expected_price
     *
     * @return \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOfferExpectedPrice|null
     */
    public function getFeaturedOfferExpectedPrice()
    {
        return $this->container['featured_offer_expected_price'];
    }

    /**
     * Sets featured_offer_expected_price
     *
     * @param \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOfferExpectedPrice|null $featured_offer_expected_price featured_offer_expected_price
     *
     * @return self
     */
    public function setFeaturedOfferExpectedPrice($featured_offer_expected_price)
    {
        $this->container['featured_offer_expected_price'] = $featured_offer_expected_price;

        return $this;
    }
    /**
     * Gets result_status
     *
     * @return string
     */
    public function getResultStatus()
    {
        return $this->container['result_status'];
    }

    /**
     * Sets result_status
     *
     * @param string $result_status The status of the featured offer expected price computation. Possible values include VALID_FOEP, NO_COMPETING_OFFER, OFFER_NOT_ELIGIBLE, OFFER_NOT_FOUND.
     *
     * @return self
     */
    public function setResultStatus($result_status)
    {
        $this->container['result_status'] = $result_status;

        return $this;
    }
    /**
     * Gets competing_featured_offer
     *
     * @return \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOffer|null
     */
    public function getCompetingFeaturedOffer()
    {
        return $this->container['competing_featured_offer'];
    }

    /**
     * Sets competing_featured_offer
     *
     * @param \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOffer|null $competing_featured_offer competing_featured_offer
     *
     * @return self
     */
    public function setCompetingFeaturedOffer($competing_featured_offer)
    {
        $this->container['competing_featured_offer'] = $competing_featured_offer;

        return $this;
    }
    /**
     * Gets current_featured_offer
     *
     * @return \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOffer|null
     */
    public function getCurrentFeaturedOffer()
    {
        return $this->container['current_featured_offer'];
    }

    /**
     * Sets current_featured_offer
     *
     * @param \SellingPartnerApi\Model\ProductPricingV20220501\FeaturedOffer|null $current_featured_offer current_featured_offer
     *
     * @return self
     */
    public function setCurrentFeaturedOffer($current_featured_offer)
    {
        $this->container['current_featured_offer'] = $current_featured_offer;

        return $this;
    }
}


