<?php
/**
 * OldCatalogApi
 * PHP version 7.2
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Catalog Items
 *
 * The Selling Partner API for Catalog Items helps you programmatically retrieve item details for items in the catalog.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SellingPartnerApi\ApiException;
use SellingPartnerApi\Configuration;
use SellingPartnerApi\HeaderSelector;
use SellingPartnerApi\ObjectSerializer;

/**
 * OldCatalogApi Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 */
class OldCatalogApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param Configuration   $config
     * @param ClientInterface $client
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        Configuration $config,
        ClientInterface $client = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config;
        $this->headerSelector = $selector ?: new HeaderSelector($this->config);
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex)
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getCatalogItem
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse
     */
    public function getCatalogItem($marketplace_id, $asin)
    {
        $response = $this->getCatalogItemWithHttpInfo($marketplace_id, $asin);
        return $response;
    }

    /**
     * Operation getCatalogItemWithHttpInfo
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCatalogItemWithHttpInfo($marketplace_id, $asin)
    {
        $request = $this->getCatalogItemRequest($marketplace_id, $asin);
        $signedRequest = $this->config->signRequest(
            $request
        );

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getResponse()->getBody()->getContents()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
                case 401:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCatalogItemAsync
     *
     * 
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCatalogItemAsync($marketplace_id, $asin)
    {
        return $this->getCatalogItemAsyncWithHttpInfo($marketplace_id, $asin)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCatalogItemAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCatalogItemAsyncWithHttpInfo($marketplace_id, $asin)
    {
        $returnType = '\SellingPartnerApi\Model\OldCatalog\GetCatalogItemResponse';
        $request = $this->getCatalogItemRequest($marketplace_id, $asin);
        $signedRequest = $this->config->signRequest(
            $request
        );

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()->getContents()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCatalogItem'
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCatalogItemRequest($marketplace_id, $asin)
    {
        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling getCatalogItem'
            );
        }
        // verify the required parameter 'asin' is set
        if ($asin === null || (is_array($asin) && count($asin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $asin when calling getCatalogItem'
            );
        }

        $resourcePath = '/catalog/v0/items/{asin}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_id)) {
            $marketplace_id = ObjectSerializer::serializeCollection($marketplace_id, '', true);
        }
        if ($marketplace_id !== null) {
            $queryParams['MarketplaceId'] = $marketplace_id;
        }

        // path params
        if ($asin !== null) {
            $resourcePath = str_replace(
                '{' . 'asin' . '}',
                ObjectSerializer::toPathValue($asin),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listCatalogCategories
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (optional)
     * @param  string $seller_sku Used to identify items in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse
     */
    public function listCatalogCategories($marketplace_id, $asin = null, $seller_sku = null)
    {
        $response = $this->listCatalogCategoriesWithHttpInfo($marketplace_id, $asin, $seller_sku);
        return $response;
    }

    /**
     * Operation listCatalogCategoriesWithHttpInfo
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (optional)
     * @param  string $seller_sku Used to identify items in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCatalogCategoriesWithHttpInfo($marketplace_id, $asin = null, $seller_sku = null)
    {
        $request = $this->listCatalogCategoriesRequest($marketplace_id, $asin, $seller_sku);
        $signedRequest = $this->config->signRequest(
            $request
        );

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getResponse()->getBody()->getContents()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
                case 401:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listCatalogCategoriesAsync
     *
     * 
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (optional)
     * @param  string $seller_sku Used to identify items in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCatalogCategoriesAsync($marketplace_id, $asin = null, $seller_sku = null)
    {
        return $this->listCatalogCategoriesAsyncWithHttpInfo($marketplace_id, $asin, $seller_sku)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listCatalogCategoriesAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (optional)
     * @param  string $seller_sku Used to identify items in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCatalogCategoriesAsyncWithHttpInfo($marketplace_id, $asin = null, $seller_sku = null)
    {
        $returnType = '\SellingPartnerApi\Model\OldCatalog\ListCatalogCategoriesResponse';
        $request = $this->listCatalogCategoriesRequest($marketplace_id, $asin, $seller_sku);
        $signedRequest = $this->config->signRequest(
            $request
        );

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()->getContents()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listCatalogCategories'
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for the item. (required)
     * @param  string $asin The Amazon Standard Identification Number (ASIN) of the item. (optional)
     * @param  string $seller_sku Used to identify items in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listCatalogCategoriesRequest($marketplace_id, $asin = null, $seller_sku = null)
    {
        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling listCatalogCategories'
            );
        }

        $resourcePath = '/catalog/v0/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_id)) {
            $marketplace_id = ObjectSerializer::serializeCollection($marketplace_id, '', true);
        }
        if ($marketplace_id !== null) {
            $queryParams['MarketplaceId'] = $marketplace_id;
        }

        // query params
        if (is_array($asin)) {
            $asin = ObjectSerializer::serializeCollection($asin, '', true);
        }
        if ($asin !== null) {
            $queryParams['ASIN'] = $asin;
        }

        // query params
        if (is_array($seller_sku)) {
            $seller_sku = ObjectSerializer::serializeCollection($seller_sku, '', true);
        }
        if ($seller_sku !== null) {
            $queryParams['SellerSKU'] = $seller_sku;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listCatalogItems
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for which items are returned. (required)
     * @param  string $query Keyword(s) to use to search for items in the catalog. Example: &#39;harry potter books&#39;. (optional)
     * @param  string $query_context_id An identifier for the context within which the given search will be performed. A marketplace might provide mechanisms for constraining a search to a subset of potential items. For example, the retail marketplace allows queries to be constrained to a specific category. The QueryContextId parameter specifies such a subset. If it is omitted, the search will be performed using the default context for the marketplace, which will typically contain the largest set of items. (optional)
     * @param  string $seller_sku Used to identify an item in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     * @param  string $upc A 12-digit bar code used for retail packaging. (optional)
     * @param  string $ean A European article number that uniquely identifies the catalog item, manufacturer, and its attributes. (optional)
     * @param  string $isbn The unique commercial book identifier used to identify books internationally. (optional)
     * @param  string $jan A Japanese article number that uniquely identifies the product, manufacturer, and its attributes. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse
     */
    public function listCatalogItems($marketplace_id, $query = null, $query_context_id = null, $seller_sku = null, $upc = null, $ean = null, $isbn = null, $jan = null)
    {
        $response = $this->listCatalogItemsWithHttpInfo($marketplace_id, $query, $query_context_id, $seller_sku, $upc, $ean, $isbn, $jan);
        return $response;
    }

    /**
     * Operation listCatalogItemsWithHttpInfo
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for which items are returned. (required)
     * @param  string $query Keyword(s) to use to search for items in the catalog. Example: &#39;harry potter books&#39;. (optional)
     * @param  string $query_context_id An identifier for the context within which the given search will be performed. A marketplace might provide mechanisms for constraining a search to a subset of potential items. For example, the retail marketplace allows queries to be constrained to a specific category. The QueryContextId parameter specifies such a subset. If it is omitted, the search will be performed using the default context for the marketplace, which will typically contain the largest set of items. (optional)
     * @param  string $seller_sku Used to identify an item in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     * @param  string $upc A 12-digit bar code used for retail packaging. (optional)
     * @param  string $ean A European article number that uniquely identifies the catalog item, manufacturer, and its attributes. (optional)
     * @param  string $isbn The unique commercial book identifier used to identify books internationally. (optional)
     * @param  string $jan A Japanese article number that uniquely identifies the product, manufacturer, and its attributes. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCatalogItemsWithHttpInfo($marketplace_id, $query = null, $query_context_id = null, $seller_sku = null, $upc = null, $ean = null, $isbn = null, $jan = null)
    {
        $request = $this->listCatalogItemsRequest($marketplace_id, $query, $query_context_id, $seller_sku, $upc, $ean, $isbn, $jan);
        $signedRequest = $this->config->signRequest(
            $request
        );

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getResponse()->getBody()->getContents()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
                case 401:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listCatalogItemsAsync
     *
     * 
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for which items are returned. (required)
     * @param  string $query Keyword(s) to use to search for items in the catalog. Example: &#39;harry potter books&#39;. (optional)
     * @param  string $query_context_id An identifier for the context within which the given search will be performed. A marketplace might provide mechanisms for constraining a search to a subset of potential items. For example, the retail marketplace allows queries to be constrained to a specific category. The QueryContextId parameter specifies such a subset. If it is omitted, the search will be performed using the default context for the marketplace, which will typically contain the largest set of items. (optional)
     * @param  string $seller_sku Used to identify an item in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     * @param  string $upc A 12-digit bar code used for retail packaging. (optional)
     * @param  string $ean A European article number that uniquely identifies the catalog item, manufacturer, and its attributes. (optional)
     * @param  string $isbn The unique commercial book identifier used to identify books internationally. (optional)
     * @param  string $jan A Japanese article number that uniquely identifies the product, manufacturer, and its attributes. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCatalogItemsAsync($marketplace_id, $query = null, $query_context_id = null, $seller_sku = null, $upc = null, $ean = null, $isbn = null, $jan = null)
    {
        return $this->listCatalogItemsAsyncWithHttpInfo($marketplace_id, $query, $query_context_id, $seller_sku, $upc, $ean, $isbn, $jan)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listCatalogItemsAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for which items are returned. (required)
     * @param  string $query Keyword(s) to use to search for items in the catalog. Example: &#39;harry potter books&#39;. (optional)
     * @param  string $query_context_id An identifier for the context within which the given search will be performed. A marketplace might provide mechanisms for constraining a search to a subset of potential items. For example, the retail marketplace allows queries to be constrained to a specific category. The QueryContextId parameter specifies such a subset. If it is omitted, the search will be performed using the default context for the marketplace, which will typically contain the largest set of items. (optional)
     * @param  string $seller_sku Used to identify an item in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     * @param  string $upc A 12-digit bar code used for retail packaging. (optional)
     * @param  string $ean A European article number that uniquely identifies the catalog item, manufacturer, and its attributes. (optional)
     * @param  string $isbn The unique commercial book identifier used to identify books internationally. (optional)
     * @param  string $jan A Japanese article number that uniquely identifies the product, manufacturer, and its attributes. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCatalogItemsAsyncWithHttpInfo($marketplace_id, $query = null, $query_context_id = null, $seller_sku = null, $upc = null, $ean = null, $isbn = null, $jan = null)
    {
        $returnType = '\SellingPartnerApi\Model\OldCatalog\ListCatalogItemsResponse';
        $request = $this->listCatalogItemsRequest($marketplace_id, $query, $query_context_id, $seller_sku, $upc, $ean, $isbn, $jan);
        $signedRequest = $this->config->signRequest(
            $request
        );

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()->getContents()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listCatalogItems'
     *
     * @param  string $marketplace_id A marketplace identifier. Specifies the marketplace for which items are returned. (required)
     * @param  string $query Keyword(s) to use to search for items in the catalog. Example: &#39;harry potter books&#39;. (optional)
     * @param  string $query_context_id An identifier for the context within which the given search will be performed. A marketplace might provide mechanisms for constraining a search to a subset of potential items. For example, the retail marketplace allows queries to be constrained to a specific category. The QueryContextId parameter specifies such a subset. If it is omitted, the search will be performed using the default context for the marketplace, which will typically contain the largest set of items. (optional)
     * @param  string $seller_sku Used to identify an item in the given marketplace. SellerSKU is qualified by the seller&#39;s SellerId, which is included with every operation that you submit. (optional)
     * @param  string $upc A 12-digit bar code used for retail packaging. (optional)
     * @param  string $ean A European article number that uniquely identifies the catalog item, manufacturer, and its attributes. (optional)
     * @param  string $isbn The unique commercial book identifier used to identify books internationally. (optional)
     * @param  string $jan A Japanese article number that uniquely identifies the product, manufacturer, and its attributes. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listCatalogItemsRequest($marketplace_id, $query = null, $query_context_id = null, $seller_sku = null, $upc = null, $ean = null, $isbn = null, $jan = null)
    {
        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling listCatalogItems'
            );
        }

        $resourcePath = '/catalog/v0/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_id)) {
            $marketplace_id = ObjectSerializer::serializeCollection($marketplace_id, '', true);
        }
        if ($marketplace_id !== null) {
            $queryParams['MarketplaceId'] = $marketplace_id;
        }

        // query params
        if (is_array($query)) {
            $query = ObjectSerializer::serializeCollection($query, '', true);
        }
        if ($query !== null) {
            $queryParams['Query'] = $query;
        }

        // query params
        if (is_array($query_context_id)) {
            $query_context_id = ObjectSerializer::serializeCollection($query_context_id, '', true);
        }
        if ($query_context_id !== null) {
            $queryParams['QueryContextId'] = $query_context_id;
        }

        // query params
        if (is_array($seller_sku)) {
            $seller_sku = ObjectSerializer::serializeCollection($seller_sku, '', true);
        }
        if ($seller_sku !== null) {
            $queryParams['SellerSKU'] = $seller_sku;
        }

        // query params
        if (is_array($upc)) {
            $upc = ObjectSerializer::serializeCollection($upc, '', true);
        }
        if ($upc !== null) {
            $queryParams['UPC'] = $upc;
        }

        // query params
        if (is_array($ean)) {
            $ean = ObjectSerializer::serializeCollection($ean, '', true);
        }
        if ($ean !== null) {
            $queryParams['EAN'] = $ean;
        }

        // query params
        if (is_array($isbn)) {
            $isbn = ObjectSerializer::serializeCollection($isbn, '', true);
        }
        if ($isbn !== null) {
            $queryParams['ISBN'] = $isbn;
        }

        // query params
        if (is_array($jan)) {
            $jan = ObjectSerializer::serializeCollection($jan, '', true);
        }
        if ($jan !== null) {
            $queryParams['JAN'] = $jan;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
