<?php
/**
 * ResearchingQuantity
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for FBA Inventory
 *
 * The Selling Partner API for FBA Inventory lets you programmatically retrieve information about inventory in Amazon's fulfillment network.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FbaInventoryV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * ResearchingQuantity Class Doc Comment
 *
 * @category Class
 * @description The number of misplaced or warehouse damaged units that are actively being confirmed at our fulfillment centers.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ResearchingQuantity extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ResearchingQuantity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'total_researching_quantity' => 'int',
        'researching_quantity_breakdown' => '\SellingPartnerApi\Model\FbaInventoryV1\ResearchingQuantityEntry[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'total_researching_quantity' => null,
        'researching_quantity_breakdown' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'total_researching_quantity' => 'totalResearchingQuantity',
        'researching_quantity_breakdown' => 'researchingQuantityBreakdown'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'total_researching_quantity' => 'setTotalResearchingQuantity',
        'researching_quantity_breakdown' => 'setResearchingQuantityBreakdown'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'total_researching_quantity' => 'getTotalResearchingQuantity',
        'researching_quantity_breakdown' => 'getResearchingQuantityBreakdown'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['total_researching_quantity'] = $data['total_researching_quantity'] ?? null;
        $this->container['researching_quantity_breakdown'] = $data['researching_quantity_breakdown'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets total_researching_quantity
     *
     * @return int|null
     */
    public function getTotalResearchingQuantity()
    {
        return $this->container['total_researching_quantity'];
    }

    /**
     * Sets total_researching_quantity
     *
     * @param int|null $total_researching_quantity The total number of units currently being researched in Amazon's fulfillment network.
     *
     * @return self
     */
    public function setTotalResearchingQuantity($total_researching_quantity)
    {
        $this->container['total_researching_quantity'] = $total_researching_quantity;

        return $this;
    }
    /**
     * Gets researching_quantity_breakdown
     *
     * @return \SellingPartnerApi\Model\FbaInventoryV1\ResearchingQuantityEntry[]|null
     */
    public function getResearchingQuantityBreakdown()
    {
        return $this->container['researching_quantity_breakdown'];
    }

    /**
     * Sets researching_quantity_breakdown
     *
     * @param \SellingPartnerApi\Model\FbaInventoryV1\ResearchingQuantityEntry[]|null $researching_quantity_breakdown A list of quantity details for items currently being researched.
     *
     * @return self
     */
    public function setResearchingQuantityBreakdown($researching_quantity_breakdown)
    {
        $this->container['researching_quantity_breakdown'] = $researching_quantity_breakdown;

        return $this;
    }
}


