<?php
/**
 * TransportResult
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Fulfillment Inbound
 *
 * The Selling Partner API for Fulfillment Inbound lets you create applications that create and update inbound shipments of inventory to Amazon's fulfillment network.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FbaInboundV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * TransportResult Class Doc Comment
 *
 * @category Class
 * @description The workflow status for a shipment with an Amazon-partnered carrier.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class TransportResult extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransportResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transport_status' => '\SellingPartnerApi\Model\FbaInboundV0\TransportStatus',
        'error_code' => 'string',
        'error_description' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transport_status' => null,
        'error_code' => null,
        'error_description' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transport_status' => 'TransportStatus',
        'error_code' => 'ErrorCode',
        'error_description' => 'ErrorDescription'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transport_status' => 'setTransportStatus',
        'error_code' => 'setErrorCode',
        'error_description' => 'setErrorDescription'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transport_status' => 'getTransportStatus',
        'error_code' => 'getErrorCode',
        'error_description' => 'getErrorDescription'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transport_status'] = $data['transport_status'] ?? null;
        $this->container['error_code'] = $data['error_code'] ?? null;
        $this->container['error_description'] = $data['error_description'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['transport_status'] === null) {
            $invalidProperties[] = "'transport_status' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets transport_status
     *
     * @return \SellingPartnerApi\Model\FbaInboundV0\TransportStatus
     */
    public function getTransportStatus()
    {
        return $this->container['transport_status'];
    }

    /**
     * Sets transport_status
     *
     * @param \SellingPartnerApi\Model\FbaInboundV0\TransportStatus $transport_status transport_status
     *
     * @return self
     */
    public function setTransportStatus($transport_status)
    {
        $this->container['transport_status'] = $transport_status;

        return $this;
    }
    /**
     * Gets error_code
     *
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->container['error_code'];
    }

    /**
     * Sets error_code
     *
     * @param string|null $error_code An error code that identifies the type of error that occured.
     *
     * @return self
     */
    public function setErrorCode($error_code)
    {
        $this->container['error_code'] = $error_code;

        return $this;
    }
    /**
     * Gets error_description
     *
     * @return string|null
     */
    public function getErrorDescription()
    {
        return $this->container['error_description'];
    }

    /**
     * Sets error_description
     *
     * @param string|null $error_description A message that describes the error condition.
     *
     * @return self
     */
    public function setErrorDescription($error_description)
    {
        $this->container['error_description'] = $error_description;

        return $this;
    }
}


