<?php
/**
 * ItemApprovalActionChanges
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ItemApprovalActionChanges Class Doc Comment
 *
 * @category Class
 * @description Changes required for the approval. Each approval type defines the allowed changes valid sub-set in its specific schema.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemApprovalActionChanges extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemApprovalAction_Changes';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_price' => '\SellingPartnerApi\Model\OrdersV0\Money',
        'quantity' => 'int',
        'substituted_by' => '\SellingPartnerApi\Model\OrdersV0\ItemIdentifier'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_price' => null,
        'quantity' => null,
        'substituted_by' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_price' => 'ItemPrice',
        'quantity' => 'Quantity',
        'substituted_by' => 'SubstitutedBy'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_price' => 'setItemPrice',
        'quantity' => 'setQuantity',
        'substituted_by' => 'setSubstitutedBy'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_price' => 'getItemPrice',
        'quantity' => 'getQuantity',
        'substituted_by' => 'getSubstitutedBy'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['item_price'] = $data['item_price'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['substituted_by'] = $data['substituted_by'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets item_price
     *
     * @return \SellingPartnerApi\Model\OrdersV0\Money|null
     */
    public function getItemPrice()
    {
        return $this->container['item_price'];
    }

    /**
     * Sets item_price
     *
     * @param \SellingPartnerApi\Model\OrdersV0\Money|null $item_price item_price
     *
     * @return self
     */
    public function setItemPrice($item_price)
    {
        $this->container['item_price'] = $item_price;

        return $this;
    }
    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity approved. If substitutedBy is specified, this value applies to the substitution item.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }
    /**
     * Gets substituted_by
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemIdentifier|null
     */
    public function getSubstitutedBy()
    {
        return $this->container['substituted_by'];
    }

    /**
     * Sets substituted_by
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemIdentifier|null $substituted_by substituted_by
     *
     * @return self
     */
    public function setSubstitutedBy($substituted_by)
    {
        $this->container['substituted_by'] = $substituted_by;

        return $this;
    }
}


