<?php
/**
 * OrderAddress
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * OrderAddress Class Doc Comment
 *
 * @category Class
 * @description The shipping address for the order.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class OrderAddress extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderAddress';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'amazon_order_id' => 'string',
        'buyer_company_name' => 'string',
        'shipping_address' => '\SellingPartnerApi\Model\OrdersV0\Address',
        'delivery_preferences' => '\SellingPartnerApi\Model\OrdersV0\DeliveryPreferences'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'amazon_order_id' => null,
        'buyer_company_name' => null,
        'shipping_address' => null,
        'delivery_preferences' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'amazon_order_id' => 'AmazonOrderId',
        'buyer_company_name' => 'BuyerCompanyName',
        'shipping_address' => 'ShippingAddress',
        'delivery_preferences' => 'DeliveryPreferences'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'amazon_order_id' => 'setAmazonOrderId',
        'buyer_company_name' => 'setBuyerCompanyName',
        'shipping_address' => 'setShippingAddress',
        'delivery_preferences' => 'setDeliveryPreferences'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'amazon_order_id' => 'getAmazonOrderId',
        'buyer_company_name' => 'getBuyerCompanyName',
        'shipping_address' => 'getShippingAddress',
        'delivery_preferences' => 'getDeliveryPreferences'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['amazon_order_id'] = $data['amazon_order_id'] ?? null;
        $this->container['buyer_company_name'] = $data['buyer_company_name'] ?? null;
        $this->container['shipping_address'] = $data['shipping_address'] ?? null;
        $this->container['delivery_preferences'] = $data['delivery_preferences'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['amazon_order_id'] === null) {
            $invalidProperties[] = "'amazon_order_id' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets amazon_order_id
     *
     * @return string
     */
    public function getAmazonOrderId()
    {
        return $this->container['amazon_order_id'];
    }

    /**
     * Sets amazon_order_id
     *
     * @param string $amazon_order_id An Amazon-defined order identifier, in 3-7-7 format.
     *
     * @return self
     */
    public function setAmazonOrderId($amazon_order_id)
    {
        $this->container['amazon_order_id'] = $amazon_order_id;

        return $this;
    }
    /**
     * Gets buyer_company_name
     *
     * @return string|null
     */
    public function getBuyerCompanyName()
    {
        return $this->container['buyer_company_name'];
    }

    /**
     * Sets buyer_company_name
     *
     * @param string|null $buyer_company_name Company name of the destination address.
     *
     * @return self
     */
    public function setBuyerCompanyName($buyer_company_name)
    {
        $this->container['buyer_company_name'] = $buyer_company_name;

        return $this;
    }
    /**
     * Gets shipping_address
     *
     * @return \SellingPartnerApi\Model\OrdersV0\Address|null
     */
    public function getShippingAddress()
    {
        return $this->container['shipping_address'];
    }

    /**
     * Sets shipping_address
     *
     * @param \SellingPartnerApi\Model\OrdersV0\Address|null $shipping_address shipping_address
     *
     * @return self
     */
    public function setShippingAddress($shipping_address)
    {
        $this->container['shipping_address'] = $shipping_address;

        return $this;
    }
    /**
     * Gets delivery_preferences
     *
     * @return \SellingPartnerApi\Model\OrdersV0\DeliveryPreferences|null
     */
    public function getDeliveryPreferences()
    {
        return $this->container['delivery_preferences'];
    }

    /**
     * Sets delivery_preferences
     *
     * @param \SellingPartnerApi\Model\OrdersV0\DeliveryPreferences|null $delivery_preferences delivery_preferences
     *
     * @return self
     */
    public function setDeliveryPreferences($delivery_preferences)
    {
        $this->container['delivery_preferences'] = $delivery_preferences;

        return $this;
    }
}


