<?php
/**
 * ItemApprovalAction
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ItemApprovalAction Class Doc Comment
 *
 * @category Class
 * @description This object represents an approval action used by the actors in the order item approval process. Check the applicable restrictions at the specific approval type schemas.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemApprovalAction extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemApprovalAction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'action_type' => 'string',
        'comment' => 'string',
        'changes' => '\SellingPartnerApi\Model\OrdersV0\ItemApprovalActionChanges'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'action_type' => null,
        'comment' => null,
        'changes' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'action_type' => 'ActionType',
        'comment' => 'Comment',
        'changes' => 'Changes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'action_type' => 'setActionType',
        'comment' => 'setComment',
        'changes' => 'setChanges'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'action_type' => 'getActionType',
        'comment' => 'getComment',
        'changes' => 'getChanges'
    ];



    const ACTION_TYPE_APPROVE = 'APPROVE';
    const ACTION_TYPE_DECLINE = 'DECLINE';
    const ACTION_TYPE_APPROVE_WITH_CHANGES = 'APPROVE_WITH_CHANGES';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getActionTypeAllowableValues()
    {
        $baseVals = [
            self::ACTION_TYPE_APPROVE,
            self::ACTION_TYPE_DECLINE,
            self::ACTION_TYPE_APPROVE_WITH_CHANGES,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['action_type'] = $data['action_type'] ?? null;
        $this->container['comment'] = $data['comment'] ?? null;
        $this->container['changes'] = $data['changes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['action_type'] === null) {
            $invalidProperties[] = "'action_type' can't be null";
        }
        $allowedValues = $this->getActionTypeAllowableValues();
        if (
            !is_null($this->container['action_type']) &&
            !in_array(strtoupper($this->container['action_type']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'action_type', must be one of '%s'",
                $this->container['action_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets action_type
     *
     * @return string
     */
    public function getActionType()
    {
        return $this->container['action_type'];
    }

    /**
     * Sets action_type
     *
     * @param string $action_type Defines the type of action for the approval.
     *
     * @return self
     */
    public function setActionType($action_type)
    {
        $allowedValues = $this->getActionTypeAllowableValues();
        if (!in_array(strtoupper($action_type), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'action_type', must be one of '%s'",
                    $action_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['action_type'] = $action_type;

        return $this;
    }
    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment Comment message to provide optional additional context on the approval action.
     *
     * @return self
     */
    public function setComment($comment)
    {
        $this->container['comment'] = $comment;

        return $this;
    }
    /**
     * Gets changes
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemApprovalActionChanges|null
     */
    public function getChanges()
    {
        return $this->container['changes'];
    }

    /**
     * Sets changes
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemApprovalActionChanges|null $changes changes
     *
     * @return self
     */
    public function setChanges($changes)
    {
        $this->container['changes'] = $changes;

        return $this;
    }
}


