<?php
/**
 * FailedAdhocDisbursementEventList
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Finances
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FinancesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * FailedAdhocDisbursementEventList Class Doc Comment
 *
 * @category Class
 * @description Failed ad hoc disbursement event list.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class FailedAdhocDisbursementEventList extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FailedAdhocDisbursementEventList';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'funds_transfers_type' => 'string',
        'transfer_id' => 'string',
        'disbursement_id' => 'string',
        'payment_disbursement_type' => 'string',
        'status' => 'string',
        'transfer_amount' => '\SellingPartnerApi\Model\FinancesV0\Currency',
        'posted_date' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'funds_transfers_type' => null,
        'transfer_id' => null,
        'disbursement_id' => null,
        'payment_disbursement_type' => null,
        'status' => null,
        'transfer_amount' => null,
        'posted_date' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'funds_transfers_type' => 'FundsTransfersType',
        'transfer_id' => 'TransferId',
        'disbursement_id' => 'DisbursementId',
        'payment_disbursement_type' => 'PaymentDisbursementType',
        'status' => 'Status',
        'transfer_amount' => 'TransferAmount',
        'posted_date' => 'PostedDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'funds_transfers_type' => 'setFundsTransfersType',
        'transfer_id' => 'setTransferId',
        'disbursement_id' => 'setDisbursementId',
        'payment_disbursement_type' => 'setPaymentDisbursementType',
        'status' => 'setStatus',
        'transfer_amount' => 'setTransferAmount',
        'posted_date' => 'setPostedDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'funds_transfers_type' => 'getFundsTransfersType',
        'transfer_id' => 'getTransferId',
        'disbursement_id' => 'getDisbursementId',
        'payment_disbursement_type' => 'getPaymentDisbursementType',
        'status' => 'getStatus',
        'transfer_amount' => 'getTransferAmount',
        'posted_date' => 'getPostedDate'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['funds_transfers_type'] = $data['funds_transfers_type'] ?? null;
        $this->container['transfer_id'] = $data['transfer_id'] ?? null;
        $this->container['disbursement_id'] = $data['disbursement_id'] ?? null;
        $this->container['payment_disbursement_type'] = $data['payment_disbursement_type'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['transfer_amount'] = $data['transfer_amount'] ?? null;
        $this->container['posted_date'] = $data['posted_date'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets funds_transfers_type
     *
     * @return string|null
     */
    public function getFundsTransfersType()
    {
        return $this->container['funds_transfers_type'];
    }

    /**
     * Sets funds_transfers_type
     *
     * @param string|null $funds_transfers_type The type of fund transfer. 
     *   Example \"Refund\"
     *
     * @return self
     */
    public function setFundsTransfersType($funds_transfers_type)
    {
        $this->container['funds_transfers_type'] = $funds_transfers_type;

        return $this;
    }
    /**
     * Gets transfer_id
     *
     * @return string|null
     */
    public function getTransferId()
    {
        return $this->container['transfer_id'];
    }

    /**
     * Sets transfer_id
     *
     * @param string|null $transfer_id The transfer identifier.
     *
     * @return self
     */
    public function setTransferId($transfer_id)
    {
        $this->container['transfer_id'] = $transfer_id;

        return $this;
    }
    /**
     * Gets disbursement_id
     *
     * @return string|null
     */
    public function getDisbursementId()
    {
        return $this->container['disbursement_id'];
    }

    /**
     * Sets disbursement_id
     *
     * @param string|null $disbursement_id The disbursement identifier.
     *
     * @return self
     */
    public function setDisbursementId($disbursement_id)
    {
        $this->container['disbursement_id'] = $disbursement_id;

        return $this;
    }
    /**
     * Gets payment_disbursement_type
     *
     * @return string|null
     */
    public function getPaymentDisbursementType()
    {
        return $this->container['payment_disbursement_type'];
    }

    /**
     * Sets payment_disbursement_type
     *
     * @param string|null $payment_disbursement_type The type of payment for disbursement. 
     *   Example `CREDIT_CARD`
     *
     * @return self
     */
    public function setPaymentDisbursementType($payment_disbursement_type)
    {
        $this->container['payment_disbursement_type'] = $payment_disbursement_type;

        return $this;
    }
    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The status of the failed `AdhocDisbursement`. 
     *   Example `HARD_DECLINED`
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Gets transfer_amount
     *
     * @return \SellingPartnerApi\Model\FinancesV0\Currency|null
     */
    public function getTransferAmount()
    {
        return $this->container['transfer_amount'];
    }

    /**
     * Sets transfer_amount
     *
     * @param \SellingPartnerApi\Model\FinancesV0\Currency|null $transfer_amount transfer_amount
     *
     * @return self
     */
    public function setTransferAmount($transfer_amount)
    {
        $this->container['transfer_amount'] = $transfer_amount;

        return $this;
    }
    /**
     * Gets posted_date
     *
     * @return string|null
     */
    public function getPostedDate()
    {
        return $this->container['posted_date'];
    }

    /**
     * Sets posted_date
     *
     * @param string|null $posted_date A date string in ISO 8601 format.
     *
     * @return self
     */
    public function setPostedDate($posted_date)
    {
        $this->container['posted_date'] = $posted_date;

        return $this;
    }
}


