<?php
/**
 * ItemSummaryByMarketplace
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Catalog Items
 *
 * The Selling Partner API for Catalog Items provides programmatic access to information about items in the Amazon catalog. For more information, refer to the [Catalog Items API Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/catalog-items-api-v2022-04-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2022-04-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\CatalogItemsV20220401;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ItemSummaryByMarketplace Class Doc Comment
 *
 * @category Class
 * @description Summary details of an Amazon catalog item for the indicated Amazon marketplace.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemSummaryByMarketplace extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemSummaryByMarketplace';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_id' => 'string',
        'adult_product' => 'bool',
        'autographed' => 'bool',
        'brand' => 'string',
        'browse_classification' => '\SellingPartnerApi\Model\CatalogItemsV20220401\ItemBrowseClassification',
        'color' => 'string',
        'contributors' => '\SellingPartnerApi\Model\CatalogItemsV20220401\ItemContributor[]',
        'item_classification' => 'string',
        'item_name' => 'string',
        'manufacturer' => 'string',
        'memorabilia' => 'bool',
        'model_number' => 'string',
        'package_quantity' => 'int',
        'part_number' => 'string',
        'release_date' => 'string',
        'size' => 'string',
        'style' => 'string',
        'trade_in_eligible' => 'bool',
        'website_display_group' => 'string',
        'website_display_group_name' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_id' => null,
        'adult_product' => null,
        'autographed' => null,
        'brand' => null,
        'browse_classification' => null,
        'color' => null,
        'contributors' => null,
        'item_classification' => null,
        'item_name' => null,
        'manufacturer' => null,
        'memorabilia' => null,
        'model_number' => null,
        'package_quantity' => null,
        'part_number' => null,
        'release_date' => null,
        'size' => null,
        'style' => null,
        'trade_in_eligible' => null,
        'website_display_group' => null,
        'website_display_group_name' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_id' => 'marketplaceId',
        'adult_product' => 'adultProduct',
        'autographed' => 'autographed',
        'brand' => 'brand',
        'browse_classification' => 'browseClassification',
        'color' => 'color',
        'contributors' => 'contributors',
        'item_classification' => 'itemClassification',
        'item_name' => 'itemName',
        'manufacturer' => 'manufacturer',
        'memorabilia' => 'memorabilia',
        'model_number' => 'modelNumber',
        'package_quantity' => 'packageQuantity',
        'part_number' => 'partNumber',
        'release_date' => 'releaseDate',
        'size' => 'size',
        'style' => 'style',
        'trade_in_eligible' => 'tradeInEligible',
        'website_display_group' => 'websiteDisplayGroup',
        'website_display_group_name' => 'websiteDisplayGroupName'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_id' => 'setMarketplaceId',
        'adult_product' => 'setAdultProduct',
        'autographed' => 'setAutographed',
        'brand' => 'setBrand',
        'browse_classification' => 'setBrowseClassification',
        'color' => 'setColor',
        'contributors' => 'setContributors',
        'item_classification' => 'setItemClassification',
        'item_name' => 'setItemName',
        'manufacturer' => 'setManufacturer',
        'memorabilia' => 'setMemorabilia',
        'model_number' => 'setModelNumber',
        'package_quantity' => 'setPackageQuantity',
        'part_number' => 'setPartNumber',
        'release_date' => 'setReleaseDate',
        'size' => 'setSize',
        'style' => 'setStyle',
        'trade_in_eligible' => 'setTradeInEligible',
        'website_display_group' => 'setWebsiteDisplayGroup',
        'website_display_group_name' => 'setWebsiteDisplayGroupName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_id' => 'getMarketplaceId',
        'adult_product' => 'getAdultProduct',
        'autographed' => 'getAutographed',
        'brand' => 'getBrand',
        'browse_classification' => 'getBrowseClassification',
        'color' => 'getColor',
        'contributors' => 'getContributors',
        'item_classification' => 'getItemClassification',
        'item_name' => 'getItemName',
        'manufacturer' => 'getManufacturer',
        'memorabilia' => 'getMemorabilia',
        'model_number' => 'getModelNumber',
        'package_quantity' => 'getPackageQuantity',
        'part_number' => 'getPartNumber',
        'release_date' => 'getReleaseDate',
        'size' => 'getSize',
        'style' => 'getStyle',
        'trade_in_eligible' => 'getTradeInEligible',
        'website_display_group' => 'getWebsiteDisplayGroup',
        'website_display_group_name' => 'getWebsiteDisplayGroupName'
    ];



    const ITEM_CLASSIFICATION_BASE_PRODUCT = 'BASE_PRODUCT';
    const ITEM_CLASSIFICATION_OTHER = 'OTHER';
    const ITEM_CLASSIFICATION_PRODUCT_BUNDLE = 'PRODUCT_BUNDLE';
    const ITEM_CLASSIFICATION_VARIATION_PARENT = 'VARIATION_PARENT';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getItemClassificationAllowableValues()
    {
        $baseVals = [
            self::ITEM_CLASSIFICATION_BASE_PRODUCT,
            self::ITEM_CLASSIFICATION_OTHER,
            self::ITEM_CLASSIFICATION_PRODUCT_BUNDLE,
            self::ITEM_CLASSIFICATION_VARIATION_PARENT,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['adult_product'] = $data['adult_product'] ?? null;
        $this->container['autographed'] = $data['autographed'] ?? null;
        $this->container['brand'] = $data['brand'] ?? null;
        $this->container['browse_classification'] = $data['browse_classification'] ?? null;
        $this->container['color'] = $data['color'] ?? null;
        $this->container['contributors'] = $data['contributors'] ?? null;
        $this->container['item_classification'] = $data['item_classification'] ?? null;
        $this->container['item_name'] = $data['item_name'] ?? null;
        $this->container['manufacturer'] = $data['manufacturer'] ?? null;
        $this->container['memorabilia'] = $data['memorabilia'] ?? null;
        $this->container['model_number'] = $data['model_number'] ?? null;
        $this->container['package_quantity'] = $data['package_quantity'] ?? null;
        $this->container['part_number'] = $data['part_number'] ?? null;
        $this->container['release_date'] = $data['release_date'] ?? null;
        $this->container['size'] = $data['size'] ?? null;
        $this->container['style'] = $data['style'] ?? null;
        $this->container['trade_in_eligible'] = $data['trade_in_eligible'] ?? null;
        $this->container['website_display_group'] = $data['website_display_group'] ?? null;
        $this->container['website_display_group_name'] = $data['website_display_group_name'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        $allowedValues = $this->getItemClassificationAllowableValues();
        if (
            !is_null($this->container['item_classification']) &&
            !in_array(strtoupper($this->container['item_classification']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'item_classification', must be one of '%s'",
                $this->container['item_classification'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id Amazon marketplace identifier.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets adult_product
     *
     * @return bool|null
     */
    public function getAdultProduct()
    {
        return $this->container['adult_product'];
    }

    /**
     * Sets adult_product
     *
     * @param bool|null $adult_product Identifies an Amazon catalog item is intended for an adult audience or is sexual in nature.
     *
     * @return self
     */
    public function setAdultProduct($adult_product)
    {
        $this->container['adult_product'] = $adult_product;

        return $this;
    }
    /**
     * Gets autographed
     *
     * @return bool|null
     */
    public function getAutographed()
    {
        return $this->container['autographed'];
    }

    /**
     * Sets autographed
     *
     * @param bool|null $autographed Identifies an Amazon catalog item is autographed by a player or celebrity.
     *
     * @return self
     */
    public function setAutographed($autographed)
    {
        $this->container['autographed'] = $autographed;

        return $this;
    }
    /**
     * Gets brand
     *
     * @return string|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string|null $brand Name of the brand associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setBrand($brand)
    {
        $this->container['brand'] = $brand;

        return $this;
    }
    /**
     * Gets browse_classification
     *
     * @return \SellingPartnerApi\Model\CatalogItemsV20220401\ItemBrowseClassification|null
     */
    public function getBrowseClassification()
    {
        return $this->container['browse_classification'];
    }

    /**
     * Sets browse_classification
     *
     * @param \SellingPartnerApi\Model\CatalogItemsV20220401\ItemBrowseClassification|null $browse_classification browse_classification
     *
     * @return self
     */
    public function setBrowseClassification($browse_classification)
    {
        $this->container['browse_classification'] = $browse_classification;

        return $this;
    }
    /**
     * Gets color
     *
     * @return string|null
     */
    public function getColor()
    {
        return $this->container['color'];
    }

    /**
     * Sets color
     *
     * @param string|null $color Name of the color associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setColor($color)
    {
        $this->container['color'] = $color;

        return $this;
    }
    /**
     * Gets contributors
     *
     * @return \SellingPartnerApi\Model\CatalogItemsV20220401\ItemContributor[]|null
     */
    public function getContributors()
    {
        return $this->container['contributors'];
    }

    /**
     * Sets contributors
     *
     * @param \SellingPartnerApi\Model\CatalogItemsV20220401\ItemContributor[]|null $contributors Individual contributors to the creation of an item, such as the authors or actors.
     *
     * @return self
     */
    public function setContributors($contributors)
    {
        $this->container['contributors'] = $contributors;

        return $this;
    }
    /**
     * Gets item_classification
     *
     * @return string|null
     */
    public function getItemClassification()
    {
        return $this->container['item_classification'];
    }

    /**
     * Sets item_classification
     *
     * @param string|null $item_classification Classification type associated with the Amazon catalog item.
     *
     * @return self
     */
    public function setItemClassification($item_classification)
    {
        $allowedValues = $this->getItemClassificationAllowableValues();
        if (!is_null($item_classification) &&!in_array(strtoupper($item_classification), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'item_classification', must be one of '%s'",
                    $item_classification,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['item_classification'] = $item_classification;

        return $this;
    }
    /**
     * Gets item_name
     *
     * @return string|null
     */
    public function getItemName()
    {
        return $this->container['item_name'];
    }

    /**
     * Sets item_name
     *
     * @param string|null $item_name Name, or title, associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setItemName($item_name)
    {
        $this->container['item_name'] = $item_name;

        return $this;
    }
    /**
     * Gets manufacturer
     *
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->container['manufacturer'];
    }

    /**
     * Sets manufacturer
     *
     * @param string|null $manufacturer Name of the manufacturer associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setManufacturer($manufacturer)
    {
        $this->container['manufacturer'] = $manufacturer;

        return $this;
    }
    /**
     * Gets memorabilia
     *
     * @return bool|null
     */
    public function getMemorabilia()
    {
        return $this->container['memorabilia'];
    }

    /**
     * Sets memorabilia
     *
     * @param bool|null $memorabilia Identifies an Amazon catalog item is memorabilia valued for its connection with historical events, culture, or entertainment.
     *
     * @return self
     */
    public function setMemorabilia($memorabilia)
    {
        $this->container['memorabilia'] = $memorabilia;

        return $this;
    }
    /**
     * Gets model_number
     *
     * @return string|null
     */
    public function getModelNumber()
    {
        return $this->container['model_number'];
    }

    /**
     * Sets model_number
     *
     * @param string|null $model_number Model number associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setModelNumber($model_number)
    {
        $this->container['model_number'] = $model_number;

        return $this;
    }
    /**
     * Gets package_quantity
     *
     * @return int|null
     */
    public function getPackageQuantity()
    {
        return $this->container['package_quantity'];
    }

    /**
     * Sets package_quantity
     *
     * @param int|null $package_quantity Quantity of an Amazon catalog item in one package.
     *
     * @return self
     */
    public function setPackageQuantity($package_quantity)
    {
        $this->container['package_quantity'] = $package_quantity;

        return $this;
    }
    /**
     * Gets part_number
     *
     * @return string|null
     */
    public function getPartNumber()
    {
        return $this->container['part_number'];
    }

    /**
     * Sets part_number
     *
     * @param string|null $part_number Part number associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setPartNumber($part_number)
    {
        $this->container['part_number'] = $part_number;

        return $this;
    }
    /**
     * Gets release_date
     *
     * @return string|null
     */
    public function getReleaseDate()
    {
        return $this->container['release_date'];
    }

    /**
     * Sets release_date
     *
     * @param string|null $release_date First date on which an Amazon catalog item is shippable to customers.
     *
     * @return self
     */
    public function setReleaseDate($release_date)
    {
        $this->container['release_date'] = $release_date;

        return $this;
    }
    /**
     * Gets size
     *
     * @return string|null
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     *
     * @param string|null $size Name of the size associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setSize($size)
    {
        $this->container['size'] = $size;

        return $this;
    }
    /**
     * Gets style
     *
     * @return string|null
     */
    public function getStyle()
    {
        return $this->container['style'];
    }

    /**
     * Sets style
     *
     * @param string|null $style Name of the style associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setStyle($style)
    {
        $this->container['style'] = $style;

        return $this;
    }
    /**
     * Gets trade_in_eligible
     *
     * @return bool|null
     */
    public function getTradeInEligible()
    {
        return $this->container['trade_in_eligible'];
    }

    /**
     * Sets trade_in_eligible
     *
     * @param bool|null $trade_in_eligible Identifies an Amazon catalog item is eligible for trade-in.
     *
     * @return self
     */
    public function setTradeInEligible($trade_in_eligible)
    {
        $this->container['trade_in_eligible'] = $trade_in_eligible;

        return $this;
    }
    /**
     * Gets website_display_group
     *
     * @return string|null
     */
    public function getWebsiteDisplayGroup()
    {
        return $this->container['website_display_group'];
    }

    /**
     * Sets website_display_group
     *
     * @param string|null $website_display_group Identifier of the website display group associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setWebsiteDisplayGroup($website_display_group)
    {
        $this->container['website_display_group'] = $website_display_group;

        return $this;
    }
    /**
     * Gets website_display_group_name
     *
     * @return string|null
     */
    public function getWebsiteDisplayGroupName()
    {
        return $this->container['website_display_group_name'];
    }

    /**
     * Sets website_display_group_name
     *
     * @param string|null $website_display_group_name Display name of the website display group associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setWebsiteDisplayGroupName($website_display_group_name)
    {
        $this->container['website_display_group_name'] = $website_display_group_name;

        return $this;
    }
}


