<?php
/**
 * ServiceV1Api
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Services
 *
 * With the Services API, you can build applications that help service providers get and modify their service orders and manage their resources.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Api;

use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use SellingPartnerApi\ApiException;
use SellingPartnerApi\ObjectSerializer;

/**
 * ServiceV1Api Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 */
class ServiceV1Api extends BaseApi
{
    /**
     * Operation addAppointmentForServiceJobByServiceJobId
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse
     */
    public function addAppointmentForServiceJobByServiceJobId($service_job_id, $body)
    {
        $response = $this->addAppointmentForServiceJobByServiceJobIdWithHttpInfo($service_job_id, $body);
        return $response;
    }

    /**
     * Operation addAppointmentForServiceJobByServiceJobIdWithHttpInfo
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addAppointmentForServiceJobByServiceJobIdWithHttpInfo($service_job_id, $body)
    {
        $request = $this->addAppointmentForServiceJobByServiceJobIdRequest($service_job_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation addAppointmentForServiceJobByServiceJobIdAsync
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addAppointmentForServiceJobByServiceJobIdAsync($service_job_id, $body)
    {
        return $this->addAppointmentForServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id, $body);;
    }

    /**
     * Operation addAppointmentForServiceJobByServiceJobIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addAppointmentForServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id, $body)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse';
        $request = $this->addAppointmentForServiceJobByServiceJobIdRequest($service_job_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'addAppointmentForServiceJobByServiceJobId'
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addAppointmentForServiceJobByServiceJobIdRequest($service_job_id, $body)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling addAppointmentForServiceJobByServiceJobId'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.addAppointmentForServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.addAppointmentForServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling addAppointmentForServiceJobByServiceJobId'
            );
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/appointments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation assignAppointmentResources
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesRequest $body body (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse
     */
    public function assignAppointmentResources($service_job_id, $appointment_id, $body)
    {
        $response = $this->assignAppointmentResourcesWithHttpInfo($service_job_id, $appointment_id, $body);
        return $response;
    }

    /**
     * Operation assignAppointmentResourcesWithHttpInfo
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesRequest $body (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function assignAppointmentResourcesWithHttpInfo($service_job_id, $appointment_id, $body)
    {
        $request = $this->assignAppointmentResourcesRequest($service_job_id, $appointment_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation assignAppointmentResourcesAsync
     *
     * 
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignAppointmentResourcesAsync($service_job_id, $appointment_id, $body)
    {
        return $this->assignAppointmentResourcesAsyncWithHttpInfo($service_job_id, $appointment_id, $body);;
    }

    /**
     * Operation assignAppointmentResourcesAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function assignAppointmentResourcesAsyncWithHttpInfo($service_job_id, $appointment_id, $body)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesResponse';
        $request = $this->assignAppointmentResourcesRequest($service_job_id, $appointment_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'assignAppointmentResources'
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\AssignAppointmentResourcesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function assignAppointmentResourcesRequest($service_job_id, $appointment_id, $body)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling assignAppointmentResources'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.assignAppointmentResources, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.assignAppointmentResources, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'appointment_id' is set
        if ($appointment_id === null || (is_array($appointment_id) && count($appointment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $appointment_id when calling assignAppointmentResources'
            );
        }
        if (strlen($appointment_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceV1Api.assignAppointmentResources, must be smaller than or equal to 100.');
        }
        if (strlen($appointment_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceV1Api.assignAppointmentResources, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling assignAppointmentResources'
            );
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/resources';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        // path params
        if ($appointment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appointmentId' . '}',
                ObjectSerializer::toPathValue($appointment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation cancelReservation
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\CancelReservationResponse
     */
    public function cancelReservation($reservation_id, $marketplace_ids)
    {
        $response = $this->cancelReservationWithHttpInfo($reservation_id, $marketplace_ids);
        return $response;
    }

    /**
     * Operation cancelReservationWithHttpInfo
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\CancelReservationResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function cancelReservationWithHttpInfo($reservation_id, $marketplace_ids)
    {
        $request = $this->cancelReservationRequest($reservation_id, $marketplace_ids);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 204:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 204:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation cancelReservationAsync
     *
     * 
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelReservationAsync($reservation_id, $marketplace_ids)
    {
        return $this->cancelReservationAsyncWithHttpInfo($reservation_id, $marketplace_ids);;
    }

    /**
     * Operation cancelReservationAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelReservationAsyncWithHttpInfo($reservation_id, $marketplace_ids)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\CancelReservationResponse';
        $request = $this->cancelReservationRequest($reservation_id, $marketplace_ids);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'cancelReservation'
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cancelReservationRequest($reservation_id, $marketplace_ids)
    {
        // verify the required parameter 'reservation_id' is set
        if ($reservation_id === null || (is_array($reservation_id) && count($reservation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reservation_id when calling cancelReservation'
            );
        }
        if (strlen($reservation_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$reservation_id" when calling ServiceV1Api.cancelReservation, must be smaller than or equal to 100.');
        }
        if (strlen($reservation_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$reservation_id" when calling ServiceV1Api.cancelReservation, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling cancelReservation'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.cancelReservation, number of items must be less than or equal to 1.');
        }


        $resourcePath = '/service/v1/reservation/{reservationId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // path params
        if ($reservation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'reservationId' . '}',
                ObjectSerializer::toPathValue($reservation_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation cancelServiceJobByServiceJobId
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse
     */
    public function cancelServiceJobByServiceJobId($service_job_id, $cancellation_reason_code)
    {
        $response = $this->cancelServiceJobByServiceJobIdWithHttpInfo($service_job_id, $cancellation_reason_code);
        return $response;
    }

    /**
     * Operation cancelServiceJobByServiceJobIdWithHttpInfo
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function cancelServiceJobByServiceJobIdWithHttpInfo($service_job_id, $cancellation_reason_code)
    {
        $request = $this->cancelServiceJobByServiceJobIdRequest($service_job_id, $cancellation_reason_code);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation cancelServiceJobByServiceJobIdAsync
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelServiceJobByServiceJobIdAsync($service_job_id, $cancellation_reason_code)
    {
        return $this->cancelServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id, $cancellation_reason_code);;
    }

    /**
     * Operation cancelServiceJobByServiceJobIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id, $cancellation_reason_code)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\CancelServiceJobByServiceJobIdResponse';
        $request = $this->cancelServiceJobByServiceJobIdRequest($service_job_id, $cancellation_reason_code);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'cancelServiceJobByServiceJobId'
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cancelServiceJobByServiceJobIdRequest($service_job_id, $cancellation_reason_code)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling cancelServiceJobByServiceJobId'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.cancelServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.cancelServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'cancellation_reason_code' is set
        if ($cancellation_reason_code === null || (is_array($cancellation_reason_code) && count($cancellation_reason_code) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cancellation_reason_code when calling cancelServiceJobByServiceJobId'
            );
        }
        if (strlen($cancellation_reason_code) > 100) {
            throw new \InvalidArgumentException('invalid length for "$cancellation_reason_code" when calling ServiceV1Api.cancelServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }
        if (strlen($cancellation_reason_code) < 1) {
            throw new \InvalidArgumentException('invalid length for "$cancellation_reason_code" when calling ServiceV1Api.cancelServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }
        if (!preg_match("/^[A-Z0-9_]*$/", $cancellation_reason_code)) {
            throw new \InvalidArgumentException("invalid value for \"cancellation_reason_code\" when calling ServiceV1Api.cancelServiceJobByServiceJobId, must conform to the pattern /^[A-Z0-9_]*$/.");
        }


        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/cancellations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($cancellation_reason_code)) {
            $cancellation_reason_code = ObjectSerializer::serializeCollection($cancellation_reason_code, '', true);
        }
        if ($cancellation_reason_code !== null) {
            $queryParams['cancellationReasonCode'] = $cancellation_reason_code;
        }

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation completeServiceJobByServiceJobId
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse
     */
    public function completeServiceJobByServiceJobId($service_job_id)
    {
        $response = $this->completeServiceJobByServiceJobIdWithHttpInfo($service_job_id);
        return $response;
    }

    /**
     * Operation completeServiceJobByServiceJobIdWithHttpInfo
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function completeServiceJobByServiceJobIdWithHttpInfo($service_job_id)
    {
        $request = $this->completeServiceJobByServiceJobIdRequest($service_job_id);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation completeServiceJobByServiceJobIdAsync
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeServiceJobByServiceJobIdAsync($service_job_id)
    {
        return $this->completeServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id);;
    }

    /**
     * Operation completeServiceJobByServiceJobIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\CompleteServiceJobByServiceJobIdResponse';
        $request = $this->completeServiceJobByServiceJobIdRequest($service_job_id);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'completeServiceJobByServiceJobId'
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function completeServiceJobByServiceJobIdRequest($service_job_id)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling completeServiceJobByServiceJobId'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.completeServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.completeServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }


        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/completions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReservation
     *
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\CreateReservationRequest $body Reservation details (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\CreateReservationResponse
     */
    public function createReservation($marketplace_ids, $body)
    {
        $response = $this->createReservationWithHttpInfo($marketplace_ids, $body);
        return $response;
    }

    /**
     * Operation createReservationWithHttpInfo
     *
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\CreateReservationRequest $body Reservation details (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\CreateReservationResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReservationWithHttpInfo($marketplace_ids, $body)
    {
        $request = $this->createReservationRequest($marketplace_ids, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation createReservationAsync
     *
     * 
     *
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\CreateReservationRequest $body Reservation details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReservationAsync($marketplace_ids, $body)
    {
        return $this->createReservationAsyncWithHttpInfo($marketplace_ids, $body);;
    }

    /**
     * Operation createReservationAsyncWithHttpInfo
     *
     * 
     *
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\CreateReservationRequest $body Reservation details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReservationAsyncWithHttpInfo($marketplace_ids, $body)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\CreateReservationResponse';
        $request = $this->createReservationRequest($marketplace_ids, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReservation'
     *
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\CreateReservationRequest $body Reservation details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createReservationRequest($marketplace_ids, $body)
    {
        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling createReservation'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.createReservation, number of items must be less than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createReservation'
            );
        }

        $resourcePath = '/service/v1/reservation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createServiceDocumentUploadDestination
     *
     * @param  \SellingPartnerApi\Model\ServiceV1\ServiceUploadDocument $body Upload document operation input details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination
     */
    public function createServiceDocumentUploadDestination($body)
    {
        $response = $this->createServiceDocumentUploadDestinationWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation createServiceDocumentUploadDestinationWithHttpInfo
     *
     * @param  \SellingPartnerApi\Model\ServiceV1\ServiceUploadDocument $body Upload document operation input details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination, HTTP status code, HTTP response headers (array of strings)
     */
    public function createServiceDocumentUploadDestinationWithHttpInfo($body)
    {
        $request = $this->createServiceDocumentUploadDestinationRequest($body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation createServiceDocumentUploadDestinationAsync
     *
     * 
     *
     * @param  \SellingPartnerApi\Model\ServiceV1\ServiceUploadDocument $body Upload document operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createServiceDocumentUploadDestinationAsync($body)
    {
        return $this->createServiceDocumentUploadDestinationAsyncWithHttpInfo($body);;
    }

    /**
     * Operation createServiceDocumentUploadDestinationAsyncWithHttpInfo
     *
     * 
     *
     * @param  \SellingPartnerApi\Model\ServiceV1\ServiceUploadDocument $body Upload document operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createServiceDocumentUploadDestinationAsyncWithHttpInfo($body)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\CreateServiceDocumentUploadDestination';
        $request = $this->createServiceDocumentUploadDestinationRequest($body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'createServiceDocumentUploadDestination'
     *
     * @param  \SellingPartnerApi\Model\ServiceV1\ServiceUploadDocument $body Upload document operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createServiceDocumentUploadDestinationRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createServiceDocumentUploadDestination'
            );
        }

        $resourcePath = '/service/v1/documents';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAppointmentSlots
     *
     * @param  string $asin ASIN associated with the service. (required)
     * @param  string $store_id Store identifier defining the region scope to retrive appointment slots. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace for which appointment slots are queried (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse
     */
    public function getAppointmentSlots($asin, $store_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        $response = $this->getAppointmentSlotsWithHttpInfo($asin, $store_id, $marketplace_ids, $start_time, $end_time);
        return $response;
    }

    /**
     * Operation getAppointmentSlotsWithHttpInfo
     *
     * @param  string $asin ASIN associated with the service. (required)
     * @param  string $store_id Store identifier defining the region scope to retrive appointment slots. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace for which appointment slots are queried (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAppointmentSlotsWithHttpInfo($asin, $store_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        $request = $this->getAppointmentSlotsRequest($asin, $store_id, $marketplace_ids, $start_time, $end_time);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getAppointmentSlotsAsync
     *
     * 
     *
     * @param  string $asin ASIN associated with the service. (required)
     * @param  string $store_id Store identifier defining the region scope to retrive appointment slots. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace for which appointment slots are queried (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppointmentSlotsAsync($asin, $store_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        return $this->getAppointmentSlotsAsyncWithHttpInfo($asin, $store_id, $marketplace_ids, $start_time, $end_time);;
    }

    /**
     * Operation getAppointmentSlotsAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $asin ASIN associated with the service. (required)
     * @param  string $store_id Store identifier defining the region scope to retrive appointment slots. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace for which appointment slots are queried (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppointmentSlotsAsyncWithHttpInfo($asin, $store_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse';
        $request = $this->getAppointmentSlotsRequest($asin, $store_id, $marketplace_ids, $start_time, $end_time);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAppointmentSlots'
     *
     * @param  string $asin ASIN associated with the service. (required)
     * @param  string $store_id Store identifier defining the region scope to retrive appointment slots. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace for which appointment slots are queried (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAppointmentSlotsRequest($asin, $store_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        // verify the required parameter 'asin' is set
        if ($asin === null || (is_array($asin) && count($asin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $asin when calling getAppointmentSlots'
            );
        }
        // verify the required parameter 'store_id' is set
        if ($store_id === null || (is_array($store_id) && count($store_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $store_id when calling getAppointmentSlots'
            );
        }
        if (strlen($store_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$store_id" when calling ServiceV1Api.getAppointmentSlots, must be smaller than or equal to 100.');
        }
        if (strlen($store_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$store_id" when calling ServiceV1Api.getAppointmentSlots, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling getAppointmentSlots'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.getAppointmentSlots, number of items must be less than or equal to 1.');
        }


        $resourcePath = '/service/v1/appointmentSlots';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($asin)) {
            $asin = ObjectSerializer::serializeCollection($asin, '', true);
        }
        if ($asin !== null) {
            $queryParams['asin'] = $asin;
        }

        // query params
        if (is_array($store_id)) {
            $store_id = ObjectSerializer::serializeCollection($store_id, '', true);
        }
        if ($store_id !== null) {
            $queryParams['storeId'] = $store_id;
        }

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // query params
        if (is_array($start_time)) {
            $start_time = ObjectSerializer::serializeCollection($start_time, '', true);
        }
        if ($start_time !== null) {
            $queryParams['startTime'] = $start_time;
        }

        // query params
        if (is_array($end_time)) {
            $end_time = ObjectSerializer::serializeCollection($end_time, '', true);
        }
        if ($end_time !== null) {
            $queryParams['endTime'] = $end_time;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAppointmmentSlotsByJobId
     *
     * @param  string $service_job_id A service job identifier to retrive appointment slots for associated service. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse
     */
    public function getAppointmmentSlotsByJobId($service_job_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        $response = $this->getAppointmmentSlotsByJobIdWithHttpInfo($service_job_id, $marketplace_ids, $start_time, $end_time);
        return $response;
    }

    /**
     * Operation getAppointmmentSlotsByJobIdWithHttpInfo
     *
     * @param  string $service_job_id A service job identifier to retrive appointment slots for associated service. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAppointmmentSlotsByJobIdWithHttpInfo($service_job_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        $request = $this->getAppointmmentSlotsByJobIdRequest($service_job_id, $marketplace_ids, $start_time, $end_time);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getAppointmmentSlotsByJobIdAsync
     *
     * 
     *
     * @param  string $service_job_id A service job identifier to retrive appointment slots for associated service. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppointmmentSlotsByJobIdAsync($service_job_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        return $this->getAppointmmentSlotsByJobIdAsyncWithHttpInfo($service_job_id, $marketplace_ids, $start_time, $end_time);;
    }

    /**
     * Operation getAppointmmentSlotsByJobIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id A service job identifier to retrive appointment slots for associated service. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAppointmmentSlotsByJobIdAsyncWithHttpInfo($service_job_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\GetAppointmentSlotsResponse';
        $request = $this->getAppointmmentSlotsByJobIdRequest($service_job_id, $marketplace_ids, $start_time, $end_time);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAppointmmentSlotsByJobId'
     *
     * @param  string $service_job_id A service job identifier to retrive appointment slots for associated service. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `startTime` is provided, `endTime` should also be provided. Default value is as per business configuration. (optional)
     * @param  string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If `endTime` is provided, `startTime` should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAppointmmentSlotsByJobIdRequest($service_job_id, $marketplace_ids, $start_time = null, $end_time = null)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling getAppointmmentSlotsByJobId'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.getAppointmmentSlotsByJobId, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.getAppointmmentSlotsByJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling getAppointmmentSlotsByJobId'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.getAppointmmentSlotsByJobId, number of items must be less than or equal to 1.');
        }


        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/appointmentSlots';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // query params
        if (is_array($start_time)) {
            $start_time = ObjectSerializer::serializeCollection($start_time, '', true);
        }
        if ($start_time !== null) {
            $queryParams['startTime'] = $start_time;
        }

        // query params
        if (is_array($end_time)) {
            $end_time = ObjectSerializer::serializeCollection($end_time, '', true);
        }
        if ($end_time !== null) {
            $queryParams['endTime'] = $end_time;
        }

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFixedSlotCapacity
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\FixedSlotCapacity
     */
    public function getFixedSlotCapacity($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        $response = $this->getFixedSlotCapacityWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token);
        return $response;
    }

    /**
     * Operation getFixedSlotCapacityWithHttpInfo
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\FixedSlotCapacity, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFixedSlotCapacityWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        $request = $this->getFixedSlotCapacityRequest($resource_id, $marketplace_ids, $body, $next_page_token);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacity' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacity', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 401:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacity';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getFixedSlotCapacityAsync
     *
     * 
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFixedSlotCapacityAsync($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        return $this->getFixedSlotCapacityAsyncWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token);;
    }

    /**
     * Operation getFixedSlotCapacityAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFixedSlotCapacityAsyncWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\FixedSlotCapacity';
        $request = $this->getFixedSlotCapacityRequest($resource_id, $marketplace_ids, $body, $next_page_token);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFixedSlotCapacity'
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\FixedSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFixedSlotCapacityRequest($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        // verify the required parameter 'resource_id' is set
        if ($resource_id === null || (is_array($resource_id) && count($resource_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $resource_id when calling getFixedSlotCapacity'
            );
        }
        if (strlen($resource_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$resource_id" when calling ServiceV1Api.getFixedSlotCapacity, must be smaller than or equal to 100.');
        }
        if (strlen($resource_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$resource_id" when calling ServiceV1Api.getFixedSlotCapacity, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling getFixedSlotCapacity'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.getFixedSlotCapacity, number of items must be less than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling getFixedSlotCapacity'
            );
        }

        $resourcePath = '/service/v1/serviceResources/{resourceId}/capacity/fixed';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // query params
        if (is_array($next_page_token)) {
            $next_page_token = ObjectSerializer::serializeCollection($next_page_token, '', true);
        }
        if ($next_page_token !== null) {
            $queryParams['nextPageToken'] = $next_page_token;
        }

        // path params
        if ($resource_id !== null) {
            $resourcePath = str_replace(
                '{' . 'resourceId' . '}',
                ObjectSerializer::toPathValue($resource_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRangeSlotCapacity
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\RangeSlotCapacity
     */
    public function getRangeSlotCapacity($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        $response = $this->getRangeSlotCapacityWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token);
        return $response;
    }

    /**
     * Operation getRangeSlotCapacityWithHttpInfo
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\RangeSlotCapacity, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRangeSlotCapacityWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        $request = $this->getRangeSlotCapacityRequest($resource_id, $marketplace_ids, $body, $next_page_token);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacity' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacity', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 401:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacity';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getRangeSlotCapacityAsync
     *
     * 
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRangeSlotCapacityAsync($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        return $this->getRangeSlotCapacityAsyncWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token);;
    }

    /**
     * Operation getRangeSlotCapacityAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRangeSlotCapacityAsyncWithHttpInfo($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\RangeSlotCapacity';
        $request = $this->getRangeSlotCapacityRequest($resource_id, $marketplace_ids, $body, $next_page_token);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRangeSlotCapacity'
     *
     * @param  string $resource_id Resource Identifier. (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RangeSlotCapacityQuery $body Request body. (required)
     * @param  string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRangeSlotCapacityRequest($resource_id, $marketplace_ids, $body, $next_page_token = null)
    {
        // verify the required parameter 'resource_id' is set
        if ($resource_id === null || (is_array($resource_id) && count($resource_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $resource_id when calling getRangeSlotCapacity'
            );
        }
        if (strlen($resource_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$resource_id" when calling ServiceV1Api.getRangeSlotCapacity, must be smaller than or equal to 100.');
        }
        if (strlen($resource_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$resource_id" when calling ServiceV1Api.getRangeSlotCapacity, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling getRangeSlotCapacity'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.getRangeSlotCapacity, number of items must be less than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling getRangeSlotCapacity'
            );
        }

        $resourcePath = '/service/v1/serviceResources/{resourceId}/capacity/range';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // query params
        if (is_array($next_page_token)) {
            $next_page_token = ObjectSerializer::serializeCollection($next_page_token, '', true);
        }
        if ($next_page_token !== null) {
            $queryParams['nextPageToken'] = $next_page_token;
        }

        // path params
        if ($resource_id !== null) {
            $resourcePath = str_replace(
                '{' . 'resourceId' . '}',
                ObjectSerializer::toPathValue($resource_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getServiceJobByServiceJobId
     *
     * @param  string $service_job_id A service job identifier. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse
     */
    public function getServiceJobByServiceJobId($service_job_id)
    {
        $response = $this->getServiceJobByServiceJobIdWithHttpInfo($service_job_id);
        return $response;
    }

    /**
     * Operation getServiceJobByServiceJobIdWithHttpInfo
     *
     * @param  string $service_job_id A service job identifier. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getServiceJobByServiceJobIdWithHttpInfo($service_job_id)
    {
        $request = $this->getServiceJobByServiceJobIdRequest($service_job_id);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getServiceJobByServiceJobIdAsync
     *
     * 
     *
     * @param  string $service_job_id A service job identifier. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceJobByServiceJobIdAsync($service_job_id)
    {
        return $this->getServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id);;
    }

    /**
     * Operation getServiceJobByServiceJobIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id A service job identifier. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\GetServiceJobByServiceJobIdResponse';
        $request = $this->getServiceJobByServiceJobIdRequest($service_job_id);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getServiceJobByServiceJobId'
     *
     * @param  string $service_job_id A service job identifier. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getServiceJobByServiceJobIdRequest($service_job_id)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling getServiceJobByServiceJobId'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.getServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.getServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }


        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getServiceJobs
     *
     * @param  string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param  string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param  string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param  string $page_token String returned in the response of your previous request. (optional)
     * @param  int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param  string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param  string $sort_order Sort order for the query you want to perform. (optional)
     * @param  string $created_after A date used for selecting jobs created at or after a specified time. Must be in ISO 8601 format. Required if `LastUpdatedAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $created_before A date used for selecting jobs created at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $last_updated_after A date used for selecting jobs updated at or after a specified time. Must be in ISO 8601 format. Required if `createdAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $last_updated_before A date used for selecting jobs updated at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $schedule_start_date A date used for filtering jobs schedules at or after a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string $schedule_end_date A date used for filtering jobs schedules at or before a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string[] $asins List of Amazon Standard Identification Numbers (ASIN) of the items. Max values supported is 20. (optional)
     * @param  string[] $required_skills A defined set of related knowledge, skills, experience, tools, materials, and work processes common to service delivery for a set of products and/or service scenarios. Max values supported is 20. (optional)
     * @param  string[] $store_ids List of Amazon-defined identifiers for the region scope. Max values supported is 50. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse
     */
    public function getServiceJobs($marketplace_ids, $service_order_ids = null, $service_job_status = null, $page_token = null, $page_size = 20, $sort_field = null, $sort_order = null, $created_after = null, $created_before = null, $last_updated_after = null, $last_updated_before = null, $schedule_start_date = null, $schedule_end_date = null, $asins = null, $required_skills = null, $store_ids = null)
    {
        $response = $this->getServiceJobsWithHttpInfo($marketplace_ids, $service_order_ids, $service_job_status, $page_token, $page_size, $sort_field, $sort_order, $created_after, $created_before, $last_updated_after, $last_updated_before, $schedule_start_date, $schedule_end_date, $asins, $required_skills, $store_ids);
        return $response;
    }

    /**
     * Operation getServiceJobsWithHttpInfo
     *
     * @param  string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param  string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param  string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param  string $page_token String returned in the response of your previous request. (optional)
     * @param  int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param  string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param  string $sort_order Sort order for the query you want to perform. (optional)
     * @param  string $created_after A date used for selecting jobs created at or after a specified time. Must be in ISO 8601 format. Required if `LastUpdatedAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $created_before A date used for selecting jobs created at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $last_updated_after A date used for selecting jobs updated at or after a specified time. Must be in ISO 8601 format. Required if `createdAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $last_updated_before A date used for selecting jobs updated at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $schedule_start_date A date used for filtering jobs schedules at or after a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string $schedule_end_date A date used for filtering jobs schedules at or before a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string[] $asins List of Amazon Standard Identification Numbers (ASIN) of the items. Max values supported is 20. (optional)
     * @param  string[] $required_skills A defined set of related knowledge, skills, experience, tools, materials, and work processes common to service delivery for a set of products and/or service scenarios. Max values supported is 20. (optional)
     * @param  string[] $store_ids List of Amazon-defined identifiers for the region scope. Max values supported is 50. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getServiceJobsWithHttpInfo($marketplace_ids, $service_order_ids = null, $service_job_status = null, $page_token = null, $page_size = 20, $sort_field = null, $sort_order = null, $created_after = null, $created_before = null, $last_updated_after = null, $last_updated_before = null, $schedule_start_date = null, $schedule_end_date = null, $asins = null, $required_skills = null, $store_ids = null)
    {
        $request = $this->getServiceJobsRequest($marketplace_ids, $service_order_ids, $service_job_status, $page_token, $page_size, $sort_field, $sort_order, $created_after, $created_before, $last_updated_after, $last_updated_before, $schedule_start_date, $schedule_end_date, $asins, $required_skills, $store_ids);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getServiceJobsAsync
     *
     * 
     *
     * @param  string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param  string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param  string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param  string $page_token String returned in the response of your previous request. (optional)
     * @param  int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param  string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param  string $sort_order Sort order for the query you want to perform. (optional)
     * @param  string $created_after A date used for selecting jobs created at or after a specified time. Must be in ISO 8601 format. Required if `LastUpdatedAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $created_before A date used for selecting jobs created at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $last_updated_after A date used for selecting jobs updated at or after a specified time. Must be in ISO 8601 format. Required if `createdAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $last_updated_before A date used for selecting jobs updated at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $schedule_start_date A date used for filtering jobs schedules at or after a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string $schedule_end_date A date used for filtering jobs schedules at or before a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string[] $asins List of Amazon Standard Identification Numbers (ASIN) of the items. Max values supported is 20. (optional)
     * @param  string[] $required_skills A defined set of related knowledge, skills, experience, tools, materials, and work processes common to service delivery for a set of products and/or service scenarios. Max values supported is 20. (optional)
     * @param  string[] $store_ids List of Amazon-defined identifiers for the region scope. Max values supported is 50. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceJobsAsync($marketplace_ids, $service_order_ids = null, $service_job_status = null, $page_token = null, $page_size = 20, $sort_field = null, $sort_order = null, $created_after = null, $created_before = null, $last_updated_after = null, $last_updated_before = null, $schedule_start_date = null, $schedule_end_date = null, $asins = null, $required_skills = null, $store_ids = null)
    {
        return $this->getServiceJobsAsyncWithHttpInfo($marketplace_ids, $service_order_ids, $service_job_status, $page_token, $page_size, $sort_field, $sort_order, $created_after, $created_before, $last_updated_after, $last_updated_before, $schedule_start_date, $schedule_end_date, $asins, $required_skills, $store_ids);;
    }

    /**
     * Operation getServiceJobsAsyncWithHttpInfo
     *
     * 
     *
     * @param  string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param  string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param  string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param  string $page_token String returned in the response of your previous request. (optional)
     * @param  int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param  string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param  string $sort_order Sort order for the query you want to perform. (optional)
     * @param  string $created_after A date used for selecting jobs created at or after a specified time. Must be in ISO 8601 format. Required if `LastUpdatedAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $created_before A date used for selecting jobs created at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $last_updated_after A date used for selecting jobs updated at or after a specified time. Must be in ISO 8601 format. Required if `createdAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $last_updated_before A date used for selecting jobs updated at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $schedule_start_date A date used for filtering jobs schedules at or after a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string $schedule_end_date A date used for filtering jobs schedules at or before a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string[] $asins List of Amazon Standard Identification Numbers (ASIN) of the items. Max values supported is 20. (optional)
     * @param  string[] $required_skills A defined set of related knowledge, skills, experience, tools, materials, and work processes common to service delivery for a set of products and/or service scenarios. Max values supported is 20. (optional)
     * @param  string[] $store_ids List of Amazon-defined identifiers for the region scope. Max values supported is 50. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceJobsAsyncWithHttpInfo($marketplace_ids, $service_order_ids = null, $service_job_status = null, $page_token = null, $page_size = 20, $sort_field = null, $sort_order = null, $created_after = null, $created_before = null, $last_updated_after = null, $last_updated_before = null, $schedule_start_date = null, $schedule_end_date = null, $asins = null, $required_skills = null, $store_ids = null)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\GetServiceJobsResponse';
        $request = $this->getServiceJobsRequest($marketplace_ids, $service_order_ids, $service_job_status, $page_token, $page_size, $sort_field, $sort_order, $created_after, $created_before, $last_updated_after, $last_updated_before, $schedule_start_date, $schedule_end_date, $asins, $required_skills, $store_ids);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getServiceJobs'
     *
     * @param  string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param  string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param  string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param  string $page_token String returned in the response of your previous request. (optional)
     * @param  int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param  string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param  string $sort_order Sort order for the query you want to perform. (optional)
     * @param  string $created_after A date used for selecting jobs created at or after a specified time. Must be in ISO 8601 format. Required if `LastUpdatedAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $created_before A date used for selecting jobs created at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $last_updated_after A date used for selecting jobs updated at or after a specified time. Must be in ISO 8601 format. Required if `createdAfter` is not specified. Specifying both `CreatedAfter` and `LastUpdatedAfter` returns an error. (optional)
     * @param  string $last_updated_before A date used for selecting jobs updated at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param  string $schedule_start_date A date used for filtering jobs schedules at or after a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string $schedule_end_date A date used for filtering jobs schedules at or before a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param  string[] $asins List of Amazon Standard Identification Numbers (ASIN) of the items. Max values supported is 20. (optional)
     * @param  string[] $required_skills A defined set of related knowledge, skills, experience, tools, materials, and work processes common to service delivery for a set of products and/or service scenarios. Max values supported is 20. (optional)
     * @param  string[] $store_ids List of Amazon-defined identifiers for the region scope. Max values supported is 50. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getServiceJobsRequest($marketplace_ids, $service_order_ids = null, $service_job_status = null, $page_token = null, $page_size = 20, $sort_field = null, $sort_order = null, $created_after = null, $created_before = null, $last_updated_after = null, $last_updated_before = null, $schedule_start_date = null, $schedule_end_date = null, $asins = null, $required_skills = null, $store_ids = null)
    {
        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling getServiceJobs'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.getServiceJobs, number of items must be less than or equal to 1.');
        }

        if ($service_order_ids !== null && count($service_order_ids) > 20) {
            throw new \InvalidArgumentException('invalid value for "$service_order_ids" when calling ServiceV1Api.getServiceJobs, number of items must be less than or equal to 20.');
        }
        if ($service_order_ids !== null && count($service_order_ids) < 1) {
            throw new \InvalidArgumentException('invalid value for "$service_order_ids" when calling ServiceV1Api.getServiceJobs, number of items must be greater than or equal to 1.');
        }

        if ($page_size !== null && $page_size > 20) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling ServiceV1Api.getServiceJobs, must be smaller than or equal to 20.');
        }
        if ($page_size !== null && $page_size < 1) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling ServiceV1Api.getServiceJobs, must be bigger than or equal to 1.');
        }

        if ($asins !== null && count($asins) > 20) {
            throw new \InvalidArgumentException('invalid value for "$asins" when calling ServiceV1Api.getServiceJobs, number of items must be less than or equal to 20.');
        }
        if ($asins !== null && count($asins) < 1) {
            throw new \InvalidArgumentException('invalid value for "$asins" when calling ServiceV1Api.getServiceJobs, number of items must be greater than or equal to 1.');
        }

        if ($required_skills !== null && count($required_skills) > 20) {
            throw new \InvalidArgumentException('invalid value for "$required_skills" when calling ServiceV1Api.getServiceJobs, number of items must be less than or equal to 20.');
        }
        if ($required_skills !== null && count($required_skills) < 1) {
            throw new \InvalidArgumentException('invalid value for "$required_skills" when calling ServiceV1Api.getServiceJobs, number of items must be greater than or equal to 1.');
        }

        if ($store_ids !== null && count($store_ids) > 50) {
            throw new \InvalidArgumentException('invalid value for "$store_ids" when calling ServiceV1Api.getServiceJobs, number of items must be less than or equal to 50.');
        }
        if ($store_ids !== null && count($store_ids) < 1) {
            throw new \InvalidArgumentException('invalid value for "$store_ids" when calling ServiceV1Api.getServiceJobs, number of items must be greater than or equal to 1.');
        }


        $resourcePath = '/service/v1/serviceJobs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($service_order_ids)) {
            $service_order_ids = ObjectSerializer::serializeCollection($service_order_ids, 'form', true);
        }
        if ($service_order_ids !== null) {
            $queryParams['serviceOrderIds'] = $service_order_ids;
        }

        // query params
        if (is_array($service_job_status)) {
            $service_job_status = ObjectSerializer::serializeCollection($service_job_status, 'form', true);
        }
        if ($service_job_status !== null) {
            $queryParams['serviceJobStatus'] = $service_job_status;
        }

        // query params
        if (is_array($page_token)) {
            $page_token = ObjectSerializer::serializeCollection($page_token, '', true);
        }
        if ($page_token !== null) {
            $queryParams['pageToken'] = $page_token;
        }

        // query params
        if (is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }
        if ($page_size !== null) {
            $queryParams['pageSize'] = $page_size;
        }

        // query params
        if (is_array($sort_field)) {
            $sort_field = ObjectSerializer::serializeCollection($sort_field, '', true);
        }
        if ($sort_field !== null) {
            $queryParams['sortField'] = $sort_field;
        }

        // query params
        if (is_array($sort_order)) {
            $sort_order = ObjectSerializer::serializeCollection($sort_order, '', true);
        }
        if ($sort_order !== null) {
            $queryParams['sortOrder'] = $sort_order;
        }

        // query params
        if (is_array($created_after)) {
            $created_after = ObjectSerializer::serializeCollection($created_after, '', true);
        }
        if ($created_after !== null) {
            $queryParams['createdAfter'] = $created_after;
        }

        // query params
        if (is_array($created_before)) {
            $created_before = ObjectSerializer::serializeCollection($created_before, '', true);
        }
        if ($created_before !== null) {
            $queryParams['createdBefore'] = $created_before;
        }

        // query params
        if (is_array($last_updated_after)) {
            $last_updated_after = ObjectSerializer::serializeCollection($last_updated_after, '', true);
        }
        if ($last_updated_after !== null) {
            $queryParams['lastUpdatedAfter'] = $last_updated_after;
        }

        // query params
        if (is_array($last_updated_before)) {
            $last_updated_before = ObjectSerializer::serializeCollection($last_updated_before, '', true);
        }
        if ($last_updated_before !== null) {
            $queryParams['lastUpdatedBefore'] = $last_updated_before;
        }

        // query params
        if (is_array($schedule_start_date)) {
            $schedule_start_date = ObjectSerializer::serializeCollection($schedule_start_date, '', true);
        }
        if ($schedule_start_date !== null) {
            $queryParams['scheduleStartDate'] = $schedule_start_date;
        }

        // query params
        if (is_array($schedule_end_date)) {
            $schedule_end_date = ObjectSerializer::serializeCollection($schedule_end_date, '', true);
        }
        if ($schedule_end_date !== null) {
            $queryParams['scheduleEndDate'] = $schedule_end_date;
        }

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // query params
        if (is_array($asins)) {
            $asins = ObjectSerializer::serializeCollection($asins, 'form', true);
        }
        if ($asins !== null) {
            $queryParams['asins'] = $asins;
        }

        // query params
        if (is_array($required_skills)) {
            $required_skills = ObjectSerializer::serializeCollection($required_skills, 'form', true);
        }
        if ($required_skills !== null) {
            $queryParams['requiredSkills'] = $required_skills;
        }

        // query params
        if (is_array($store_ids)) {
            $store_ids = ObjectSerializer::serializeCollection($store_ids, 'form', true);
        }
        if ($store_ids !== null) {
            $queryParams['storeIds'] = $store_ids;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation rescheduleAppointmentForServiceJobByServiceJobId
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse
     */
    public function rescheduleAppointmentForServiceJobByServiceJobId($service_job_id, $appointment_id, $body)
    {
        $response = $this->rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo($service_job_id, $appointment_id, $body);
        return $response;
    }

    /**
     * Operation rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo($service_job_id, $appointment_id, $body)
    {
        $request = $this->rescheduleAppointmentForServiceJobByServiceJobIdRequest($service_job_id, $appointment_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation rescheduleAppointmentForServiceJobByServiceJobIdAsync
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function rescheduleAppointmentForServiceJobByServiceJobIdAsync($service_job_id, $appointment_id, $body)
    {
        return $this->rescheduleAppointmentForServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id, $appointment_id, $body);;
    }

    /**
     * Operation rescheduleAppointmentForServiceJobByServiceJobIdAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function rescheduleAppointmentForServiceJobByServiceJobIdAsyncWithHttpInfo($service_job_id, $appointment_id, $body)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\SetAppointmentResponse';
        $request = $this->rescheduleAppointmentForServiceJobByServiceJobIdRequest($service_job_id, $appointment_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'rescheduleAppointmentForServiceJobByServiceJobId'
     *
     * @param  string $service_job_id An Amazon defined service job identifier. (required)
     * @param  string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function rescheduleAppointmentForServiceJobByServiceJobIdRequest($service_job_id, $appointment_id, $body)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling rescheduleAppointmentForServiceJobByServiceJobId'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.rescheduleAppointmentForServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.rescheduleAppointmentForServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'appointment_id' is set
        if ($appointment_id === null || (is_array($appointment_id) && count($appointment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $appointment_id when calling rescheduleAppointmentForServiceJobByServiceJobId'
            );
        }
        if (strlen($appointment_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceV1Api.rescheduleAppointmentForServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }
        if (strlen($appointment_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceV1Api.rescheduleAppointmentForServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling rescheduleAppointmentForServiceJobByServiceJobId'
            );
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        // path params
        if ($appointment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appointmentId' . '}',
                ObjectSerializer::toPathValue($appointment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setAppointmentFulfillmentData
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\SetAppointmentFulfillmentDataRequest $body Appointment fulfillment data collection details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string
     */
    public function setAppointmentFulfillmentData($service_job_id, $appointment_id, $body)
    {
        $response = $this->setAppointmentFulfillmentDataWithHttpInfo($service_job_id, $appointment_id, $body);
        return $response;
    }

    /**
     * Operation setAppointmentFulfillmentDataWithHttpInfo
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\SetAppointmentFulfillmentDataRequest $body Appointment fulfillment data collection details. (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function setAppointmentFulfillmentDataWithHttpInfo($service_job_id, $appointment_id, $body)
    {
        $request = $this->setAppointmentFulfillmentDataRequest($service_job_id, $appointment_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 204:
                    if ('string' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, 'string', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 422:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\Error[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\Error[]', $response->getHeaders());
            }

            $returnType = 'string';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 204:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\Error[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation setAppointmentFulfillmentDataAsync
     *
     * 
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\SetAppointmentFulfillmentDataRequest $body Appointment fulfillment data collection details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAppointmentFulfillmentDataAsync($service_job_id, $appointment_id, $body)
    {
        return $this->setAppointmentFulfillmentDataAsyncWithHttpInfo($service_job_id, $appointment_id, $body);;
    }

    /**
     * Operation setAppointmentFulfillmentDataAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\SetAppointmentFulfillmentDataRequest $body Appointment fulfillment data collection details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setAppointmentFulfillmentDataAsyncWithHttpInfo($service_job_id, $appointment_id, $body)
    {
        $returnType = 'string';
        $request = $this->setAppointmentFulfillmentDataRequest($service_job_id, $appointment_id, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'setAppointmentFulfillmentData'
     *
     * @param  string $service_job_id An Amazon-defined service job identifier. Get this value by calling the `getServiceJobs` operation of the Services API. (required)
     * @param  string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\SetAppointmentFulfillmentDataRequest $body Appointment fulfillment data collection details. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setAppointmentFulfillmentDataRequest($service_job_id, $appointment_id, $body)
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (is_array($service_job_id) && count($service_job_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling setAppointmentFulfillmentData'
            );
        }
        if (strlen($service_job_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.setAppointmentFulfillmentData, must be smaller than or equal to 100.');
        }
        if (strlen($service_job_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceV1Api.setAppointmentFulfillmentData, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'appointment_id' is set
        if ($appointment_id === null || (is_array($appointment_id) && count($appointment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $appointment_id when calling setAppointmentFulfillmentData'
            );
        }
        if (strlen($appointment_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceV1Api.setAppointmentFulfillmentData, must be smaller than or equal to 100.');
        }
        if (strlen($appointment_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceV1Api.setAppointmentFulfillmentData, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setAppointmentFulfillmentData'
            );
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/fulfillment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if ($service_job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        // path params
        if ($appointment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appointmentId' . '}',
                ObjectSerializer::toPathValue($appointment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateReservation
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateReservationRequest $body Reservation details (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse
     */
    public function updateReservation($reservation_id, $marketplace_ids, $body)
    {
        $response = $this->updateReservationWithHttpInfo($reservation_id, $marketplace_ids, $body);
        return $response;
    }

    /**
     * Operation updateReservationWithHttpInfo
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateReservationRequest $body Reservation details (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateReservationWithHttpInfo($reservation_id, $marketplace_ids, $body)
    {
        $request = $this->updateReservationRequest($reservation_id, $marketplace_ids, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation updateReservationAsync
     *
     * 
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateReservationRequest $body Reservation details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateReservationAsync($reservation_id, $marketplace_ids, $body)
    {
        return $this->updateReservationAsyncWithHttpInfo($reservation_id, $marketplace_ids, $body);;
    }

    /**
     * Operation updateReservationAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateReservationRequest $body Reservation details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateReservationAsyncWithHttpInfo($reservation_id, $marketplace_ids, $body)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\UpdateReservationResponse';
        $request = $this->updateReservationRequest($reservation_id, $marketplace_ids, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateReservation'
     *
     * @param  string $reservation_id Reservation Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateReservationRequest $body Reservation details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateReservationRequest($reservation_id, $marketplace_ids, $body)
    {
        // verify the required parameter 'reservation_id' is set
        if ($reservation_id === null || (is_array($reservation_id) && count($reservation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reservation_id when calling updateReservation'
            );
        }
        if (strlen($reservation_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$reservation_id" when calling ServiceV1Api.updateReservation, must be smaller than or equal to 100.');
        }
        if (strlen($reservation_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$reservation_id" when calling ServiceV1Api.updateReservation, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling updateReservation'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.updateReservation, number of items must be less than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updateReservation'
            );
        }

        $resourcePath = '/service/v1/reservation/{reservationId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // path params
        if ($reservation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'reservationId' . '}',
                ObjectSerializer::toPathValue($reservation_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSchedule
     *
     * @param  string $resource_id Resource (store) Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateScheduleRequest $body Schedule details (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse
     */
    public function updateSchedule($resource_id, $marketplace_ids, $body)
    {
        $response = $this->updateScheduleWithHttpInfo($resource_id, $marketplace_ids, $body);
        return $response;
    }

    /**
     * Operation updateScheduleWithHttpInfo
     *
     * @param  string $resource_id Resource (store) Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateScheduleRequest $body Schedule details (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateScheduleWithHttpInfo($resource_id, $marketplace_ids, $body)
    {
        $request = $this->updateScheduleRequest($resource_id, $marketplace_ids, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation updateScheduleAsync
     *
     * 
     *
     * @param  string $resource_id Resource (store) Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateScheduleRequest $body Schedule details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateScheduleAsync($resource_id, $marketplace_ids, $body)
    {
        return $this->updateScheduleAsyncWithHttpInfo($resource_id, $marketplace_ids, $body);;
    }

    /**
     * Operation updateScheduleAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $resource_id Resource (store) Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateScheduleRequest $body Schedule details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateScheduleAsyncWithHttpInfo($resource_id, $marketplace_ids, $body)
    {
        $returnType = '\SellingPartnerApi\Model\ServiceV1\UpdateScheduleResponse';
        $request = $this->updateScheduleRequest($resource_id, $marketplace_ids, $body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSchedule'
     *
     * @param  string $resource_id Resource (store) Identifier (required)
     * @param  string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param  \SellingPartnerApi\Model\ServiceV1\UpdateScheduleRequest $body Schedule details (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateScheduleRequest($resource_id, $marketplace_ids, $body)
    {
        // verify the required parameter 'resource_id' is set
        if ($resource_id === null || (is_array($resource_id) && count($resource_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $resource_id when calling updateSchedule'
            );
        }
        if (strlen($resource_id) > 100) {
            throw new \InvalidArgumentException('invalid length for "$resource_id" when calling ServiceV1Api.updateSchedule, must be smaller than or equal to 100.');
        }
        if (strlen($resource_id) < 1) {
            throw new \InvalidArgumentException('invalid length for "$resource_id" when calling ServiceV1Api.updateSchedule, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (is_array($marketplace_ids) && count($marketplace_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling updateSchedule'
            );
        }
        if (count($marketplace_ids) > 1) {
            throw new \InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceV1Api.updateSchedule, number of items must be less than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updateSchedule'
            );
        }

        $resourcePath = '/service/v1/serviceResources/{resourceId}/schedules';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }
        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = $marketplace_ids;
        }

        // path params
        if ($resource_id !== null) {
            $resourcePath = str_replace(
                '{' . 'resourceId' . '}',
                ObjectSerializer::toPathValue($resource_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

}
