<?php
/**
 * MerchantFulfillmentApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Evers\SellingPartnerApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Selling Partner API for Merchant Fulfillment
 *
 * The Selling Partner API for Merchant Fulfillment helps you build applications that let sellers purchase shipping for non-Prime and Prime orders using Amazon’s Buy Shipping Services.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Evers\SellingPartnerApi\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Evers\SellingPartnerApi\ApiException;
use Evers\SellingPartnerApi\Configuration;
use Evers\SellingPartnerApi\HeaderSelector;
use Evers\SellingPartnerApi\ObjectSerializer;

/**
 * MerchantFulfillmentApi Class Doc Comment
 *
 * @category Class
 * @package  Evers\SellingPartnerApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class MerchantFulfillmentApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param Configuration   $config
     * @param ClientInterface $client
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        Configuration $config = null,
        ClientInterface $client = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector($this->config);
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex)
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation cancelShipment
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse
     */
    public function cancelShipment($shipment_id)
    {
        list($response) = $this->cancelShipmentWithHttpInfo($shipment_id);
        return $response;
    }

    /**
     * Operation cancelShipmentWithHttpInfo
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function cancelShipmentWithHttpInfo($shipment_id)
    {
        $this->config->startRequestGeneration();
        $request = $this->cancelShipmentRequest($shipment_id);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\CancelShipmentResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cancelShipmentAsync
     *
     * 
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelShipmentAsync($shipment_id)
    {
        return $this->cancelShipmentAsyncWithHttpInfo($shipment_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cancelShipmentAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelShipmentAsyncWithHttpInfo($shipment_id)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\CancelShipmentResponse';
        $this->config->startRequestGeneration();
        $request = $this->cancelShipmentRequest($shipment_id);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cancelShipment'
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cancelShipmentRequest($shipment_id)
    {
        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (is_array($shipment_id) && count($shipment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling cancelShipment'
            );
        }
        if (!preg_match("/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/", $shipment_id)) {
            throw new \InvalidArgumentException("invalid value for \"shipment_id\" when calling MerchantFulfillmentApi.cancelShipment, must conform to the pattern /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/.");
        }


        $resourcePath = '/mfn/v0/shipments/{shipmentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shipment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                [],
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation cancelShipmentOld
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse
     */
    public function cancelShipmentOld($shipment_id)
    {
        list($response) = $this->cancelShipmentOldWithHttpInfo($shipment_id);
        return $response;
    }

    /**
     * Operation cancelShipmentOldWithHttpInfo
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse|\Evers\SellingPartnerApi\Model\CancelShipmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function cancelShipmentOldWithHttpInfo($shipment_id)
    {
        $this->config->startRequestGeneration();
        $request = $this->cancelShipmentOldRequest($shipment_id);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\CancelShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CancelShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\CancelShipmentResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CancelShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cancelShipmentOldAsync
     *
     * 
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelShipmentOldAsync($shipment_id)
    {
        return $this->cancelShipmentOldAsyncWithHttpInfo($shipment_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cancelShipmentOldAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelShipmentOldAsyncWithHttpInfo($shipment_id)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\CancelShipmentResponse';
        $this->config->startRequestGeneration();
        $request = $this->cancelShipmentOldRequest($shipment_id);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cancelShipmentOld'
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment to cancel. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cancelShipmentOldRequest($shipment_id)
    {
        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (is_array($shipment_id) && count($shipment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling cancelShipmentOld'
            );
        }
        if (!preg_match("/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/", $shipment_id)) {
            throw new \InvalidArgumentException("invalid value for \"shipment_id\" when calling MerchantFulfillmentApi.cancelShipmentOld, must conform to the pattern /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/.");
        }


        $resourcePath = '/mfn/v0/shipments/{shipmentId}/cancel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shipment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                [],
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createShipment
     *
     * @param  \Evers\SellingPartnerApi\Model\CreateShipmentRequest $body body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse
     */
    public function createShipment($body)
    {
        list($response) = $this->createShipmentWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation createShipmentWithHttpInfo
     *
     * @param  \Evers\SellingPartnerApi\Model\CreateShipmentRequest $body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse|\Evers\SellingPartnerApi\Model\CreateShipmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createShipmentWithHttpInfo($body)
    {
        $this->config->startRequestGeneration();
        $request = $this->createShipmentRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\CreateShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\CreateShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\CreateShipmentResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\CreateShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createShipmentAsync
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\CreateShipmentRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShipmentAsync($body)
    {
        return $this->createShipmentAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createShipmentAsyncWithHttpInfo
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\CreateShipmentRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShipmentAsyncWithHttpInfo($body)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\CreateShipmentResponse';
        $this->config->startRequestGeneration();
        $request = $this->createShipmentRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createShipment'
     *
     * @param  \Evers\SellingPartnerApi\Model\CreateShipmentRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createShipmentRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createShipment'
            );
        }

        $resourcePath = '/mfn/v0/shipments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json'],
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAdditionalSellerInputs
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse
     */
    public function getAdditionalSellerInputs($body)
    {
        list($response) = $this->getAdditionalSellerInputsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation getAdditionalSellerInputsWithHttpInfo
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAdditionalSellerInputsWithHttpInfo($body)
    {
        $this->config->startRequestGeneration();
        $request = $this->getAdditionalSellerInputsRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAdditionalSellerInputsAsync
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdditionalSellerInputsAsync($body)
    {
        return $this->getAdditionalSellerInputsAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAdditionalSellerInputsAsyncWithHttpInfo
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdditionalSellerInputsAsyncWithHttpInfo($body)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse';
        $this->config->startRequestGeneration();
        $request = $this->getAdditionalSellerInputsRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAdditionalSellerInputs'
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAdditionalSellerInputsRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling getAdditionalSellerInputs'
            );
        }

        $resourcePath = '/mfn/v0/additionalSellerInputs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json'],
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAdditionalSellerInputsOld
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse
     */
    public function getAdditionalSellerInputsOld($body)
    {
        list($response) = $this->getAdditionalSellerInputsOldWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation getAdditionalSellerInputsOldWithHttpInfo
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse|\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAdditionalSellerInputsOldWithHttpInfo($body)
    {
        $this->config->startRequestGeneration();
        $request = $this->getAdditionalSellerInputsOldRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAdditionalSellerInputsOldAsync
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdditionalSellerInputsOldAsync($body)
    {
        return $this->getAdditionalSellerInputsOldAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAdditionalSellerInputsOldAsyncWithHttpInfo
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAdditionalSellerInputsOldAsyncWithHttpInfo($body)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsResponse';
        $this->config->startRequestGeneration();
        $request = $this->getAdditionalSellerInputsOldRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAdditionalSellerInputsOld'
     *
     * @param  \Evers\SellingPartnerApi\Model\GetAdditionalSellerInputsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAdditionalSellerInputsOldRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling getAdditionalSellerInputsOld'
            );
        }

        $resourcePath = '/mfn/v0/sellerInputs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json'],
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEligibleShipmentServices
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse
     */
    public function getEligibleShipmentServices($body)
    {
        list($response) = $this->getEligibleShipmentServicesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation getEligibleShipmentServicesWithHttpInfo
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEligibleShipmentServicesWithHttpInfo($body)
    {
        $this->config->startRequestGeneration();
        $request = $this->getEligibleShipmentServicesRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEligibleShipmentServicesAsync
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEligibleShipmentServicesAsync($body)
    {
        return $this->getEligibleShipmentServicesAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEligibleShipmentServicesAsyncWithHttpInfo
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEligibleShipmentServicesAsyncWithHttpInfo($body)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse';
        $this->config->startRequestGeneration();
        $request = $this->getEligibleShipmentServicesRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEligibleShipmentServices'
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEligibleShipmentServicesRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling getEligibleShipmentServices'
            );
        }

        $resourcePath = '/mfn/v0/eligibleShippingServices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json'],
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEligibleShipmentServicesOld
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse
     */
    public function getEligibleShipmentServicesOld($body)
    {
        list($response) = $this->getEligibleShipmentServicesOldWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation getEligibleShipmentServicesOldWithHttpInfo
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse|\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEligibleShipmentServicesOldWithHttpInfo($body)
    {
        $this->config->startRequestGeneration();
        $request = $this->getEligibleShipmentServicesOldRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEligibleShipmentServicesOldAsync
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEligibleShipmentServicesOldAsync($body)
    {
        return $this->getEligibleShipmentServicesOldAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEligibleShipmentServicesOldAsyncWithHttpInfo
     *
     * 
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEligibleShipmentServicesOldAsyncWithHttpInfo($body)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesResponse';
        $this->config->startRequestGeneration();
        $request = $this->getEligibleShipmentServicesOldRequest($body);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEligibleShipmentServicesOld'
     *
     * @param  \Evers\SellingPartnerApi\Model\GetEligibleShipmentServicesRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEligibleShipmentServicesOldRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling getEligibleShipmentServicesOld'
            );
        }

        $resourcePath = '/mfn/v0/eligibleServices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json'],
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShipment
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment. (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse
     */
    public function getShipment($shipment_id)
    {
        list($response) = $this->getShipmentWithHttpInfo($shipment_id);
        return $response;
    }

    /**
     * Operation getShipmentWithHttpInfo
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment. (required)
     *
     * @throws \Evers\SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse|\Evers\SellingPartnerApi\Model\GetShipmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShipmentWithHttpInfo($shipment_id)
    {
        $this->config->startRequestGeneration();
        $request = $this->getShipmentRequest($shipment_id);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\Evers\SellingPartnerApi\Model\GetShipmentResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Evers\SellingPartnerApi\Model\GetShipmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Evers\SellingPartnerApi\Model\GetShipmentResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Evers\SellingPartnerApi\Model\GetShipmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShipmentAsync
     *
     * 
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShipmentAsync($shipment_id)
    {
        return $this->getShipmentAsyncWithHttpInfo($shipment_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShipmentAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShipmentAsyncWithHttpInfo($shipment_id)
    {
        $returnType = '\Evers\SellingPartnerApi\Model\GetShipmentResponse';
        $this->config->startRequestGeneration();
        $request = $this->getShipmentRequest($shipment_id);
        $signedRequest = $this->config->signRequest($request);
        $this->config->endRequestGeneration();

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShipment'
     *
     * @param  string $shipment_id The Amazon-defined shipment identifier for the shipment. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShipmentRequest($shipment_id)
    {
        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (is_array($shipment_id) && count($shipment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling getShipment'
            );
        }
        if (!preg_match("/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/", $shipment_id)) {
            throw new \InvalidArgumentException("invalid value for \"shipment_id\" when calling MerchantFulfillmentApi.getShipment, must conform to the pattern /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/.");
        }


        $resourcePath = '/mfn/v0/shipments/{shipmentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shipment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                [],
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
