<?php
/**
 * ContainerIdentification
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ContainerIdentification Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ContainerIdentification extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ContainerIdentification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'container_identification_type' => 'string',
        'container_identification_number' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'container_identification_type' => null,
        'container_identification_number' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'container_identification_type' => 'containerIdentificationType',
        'container_identification_number' => 'containerIdentificationNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'container_identification_type' => 'setContainerIdentificationType',
        'container_identification_number' => 'setContainerIdentificationNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'container_identification_type' => 'getContainerIdentificationType',
        'container_identification_number' => 'getContainerIdentificationNumber'
    ];



    const CONTAINER_IDENTIFICATION_TYPE_SSCC = 'SSCC';
    const CONTAINER_IDENTIFICATION_TYPE_AMZNCC = 'AMZNCC';
    const CONTAINER_IDENTIFICATION_TYPE_GTIN = 'GTIN';
    const CONTAINER_IDENTIFICATION_TYPE_BPS = 'BPS';
    const CONTAINER_IDENTIFICATION_TYPE_CID = 'CID';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getContainerIdentificationTypeAllowableValues()
    {
        $baseVals = [
            self::CONTAINER_IDENTIFICATION_TYPE_SSCC,
            self::CONTAINER_IDENTIFICATION_TYPE_AMZNCC,
            self::CONTAINER_IDENTIFICATION_TYPE_GTIN,
            self::CONTAINER_IDENTIFICATION_TYPE_BPS,
            self::CONTAINER_IDENTIFICATION_TYPE_CID,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['container_identification_type'] = $data['container_identification_type'] ?? null;
        $this->container['container_identification_number'] = $data['container_identification_number'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['container_identification_type'] === null) {
            $invalidProperties[] = "'container_identification_type' can't be null";
        }
        $allowedValues = $this->getContainerIdentificationTypeAllowableValues();
        if (
            !is_null($this->container['container_identification_type']) &&
            !in_array(strtoupper($this->container['container_identification_type']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'container_identification_type', must be one of '%s'",
                $this->container['container_identification_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['container_identification_number'] === null) {
            $invalidProperties[] = "'container_identification_number' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets container_identification_type
     *
     * @return string
     */
    public function getContainerIdentificationType()
    {
        return $this->container['container_identification_type'];
    }

    /**
     * Sets container_identification_type
     *
     * @param string $container_identification_type The container identification type.
     *
     * @return self
     */
    public function setContainerIdentificationType($container_identification_type)
    {
        $allowedValues = $this->getContainerIdentificationTypeAllowableValues();
        if (!in_array(strtoupper($container_identification_type), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'container_identification_type', must be one of '%s'",
                    $container_identification_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['container_identification_type'] = $container_identification_type;

        return $this;
    }
    /**
     * Gets container_identification_number
     *
     * @return string
     */
    public function getContainerIdentificationNumber()
    {
        return $this->container['container_identification_number'];
    }

    /**
     * Sets container_identification_number
     *
     * @param string $container_identification_number Container identification number that adheres to the definition of the container identification type.
     *
     * @return self
     */
    public function setContainerIdentificationNumber($container_identification_number)
    {
        $this->container['container_identification_number'] = $container_identification_number;

        return $this;
    }
}


