<?php
/**
 * AvailableShippingServiceOptions
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Merchant Fulfillment
 *
 * The Selling Partner API for Merchant Fulfillment helps you build applications that let sellers purchase shipping for non-Prime and Prime orders using Amazon's Buy Shipping Services.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\MerchantFulfillmentV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * AvailableShippingServiceOptions Class Doc Comment
 *
 * @category Class
 * @description The available shipping service options.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class AvailableShippingServiceOptions extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AvailableShippingServiceOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'available_carrier_will_pick_up_options' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\AvailableCarrierWillPickUpOption[]',
        'available_delivery_experience_options' => '\SellingPartnerApi\Model\MerchantFulfillmentV0\AvailableDeliveryExperienceOption[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'available_carrier_will_pick_up_options' => null,
        'available_delivery_experience_options' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'available_carrier_will_pick_up_options' => 'AvailableCarrierWillPickUpOptions',
        'available_delivery_experience_options' => 'AvailableDeliveryExperienceOptions'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'available_carrier_will_pick_up_options' => 'setAvailableCarrierWillPickUpOptions',
        'available_delivery_experience_options' => 'setAvailableDeliveryExperienceOptions'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'available_carrier_will_pick_up_options' => 'getAvailableCarrierWillPickUpOptions',
        'available_delivery_experience_options' => 'getAvailableDeliveryExperienceOptions'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['available_carrier_will_pick_up_options'] = $data['available_carrier_will_pick_up_options'] ?? null;
        $this->container['available_delivery_experience_options'] = $data['available_delivery_experience_options'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['available_carrier_will_pick_up_options'] === null) {
            $invalidProperties[] = "'available_carrier_will_pick_up_options' can't be null";
        }
        if ($this->container['available_delivery_experience_options'] === null) {
            $invalidProperties[] = "'available_delivery_experience_options' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets available_carrier_will_pick_up_options
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\AvailableCarrierWillPickUpOption[]
     */
    public function getAvailableCarrierWillPickUpOptions()
    {
        return $this->container['available_carrier_will_pick_up_options'];
    }

    /**
     * Sets available_carrier_will_pick_up_options
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\AvailableCarrierWillPickUpOption[] $available_carrier_will_pick_up_options List of available carrier pickup options.
     *
     * @return self
     */
    public function setAvailableCarrierWillPickUpOptions($available_carrier_will_pick_up_options)
    {
        $this->container['available_carrier_will_pick_up_options'] = $available_carrier_will_pick_up_options;

        return $this;
    }
    /**
     * Gets available_delivery_experience_options
     *
     * @return \SellingPartnerApi\Model\MerchantFulfillmentV0\AvailableDeliveryExperienceOption[]
     */
    public function getAvailableDeliveryExperienceOptions()
    {
        return $this->container['available_delivery_experience_options'];
    }

    /**
     * Sets available_delivery_experience_options
     *
     * @param \SellingPartnerApi\Model\MerchantFulfillmentV0\AvailableDeliveryExperienceOption[] $available_delivery_experience_options List of available delivery experience options.
     *
     * @return self
     */
    public function setAvailableDeliveryExperienceOptions($available_delivery_experience_options)
    {
        $this->container['available_delivery_experience_options'] = $available_delivery_experience_options;

        return $this;
    }
}


