<?php
/**
 * Package
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Amazon Shipping API
 *
 * The Amazon Shipping API is designed to support outbound shipping use cases both for orders originating on Amazon-owned marketplaces as well as external channels/marketplaces. With these APIs, you can request shipping rates, create shipments, cancel shipments, and track shipments.
 *
 * The version of the OpenAPI document: v2
 * Contact: swa-api-core@amazon.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ShippingV2;

use \ArrayAccess;
use \SellingPartnerApi\ObjectSerializer;
use \SellingPartnerApi\Model\ModelInterface;

/**
 * Package Class Doc Comment
 *
 * @category Class
 * @description A package to be shipped through a shipping service offering.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Package implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Package';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dimensions' => '\SellingPartnerApi\Model\ShippingV2\Dimensions',
        'weight' => '\SellingPartnerApi\Model\ShippingV2\Weight',
        'insured_value' => '\SellingPartnerApi\Model\ShippingV2\Currency',
        'is_hazmat' => 'bool',
        'seller_display_name' => 'string',
        'charges' => '\SellingPartnerApi\Model\ShippingV2\ChargeComponent[]',
        'package_client_reference_id' => 'string',
        'items' => '\SellingPartnerApi\Model\ShippingV2\Item[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dimensions' => null,
        'weight' => null,
        'insured_value' => null,
        'is_hazmat' => null,
        'seller_display_name' => null,
        'charges' => null,
        'package_client_reference_id' => null,
        'items' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dimensions' => 'dimensions',
        'weight' => 'weight',
        'insured_value' => 'insuredValue',
        'is_hazmat' => 'isHazmat',
        'seller_display_name' => 'sellerDisplayName',
        'charges' => 'charges',
        'package_client_reference_id' => 'packageClientReferenceId',
        'items' => 'items'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'dimensions' => 'setDimensions',
        'weight' => 'setWeight',
        'insured_value' => 'setInsuredValue',
        'is_hazmat' => 'setIsHazmat',
        'seller_display_name' => 'setSellerDisplayName',
        'charges' => 'setCharges',
        'package_client_reference_id' => 'setPackageClientReferenceId',
        'items' => 'setItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dimensions' => 'getDimensions',
        'weight' => 'getWeight',
        'insured_value' => 'getInsuredValue',
        'is_hazmat' => 'getIsHazmat',
        'seller_display_name' => 'getSellerDisplayName',
        'charges' => 'getCharges',
        'package_client_reference_id' => 'getPackageClientReferenceId',
        'items' => 'getItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['dimensions'] = $data['dimensions'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['insured_value'] = $data['insured_value'] ?? null;
        $this->container['is_hazmat'] = $data['is_hazmat'] ?? null;
        $this->container['seller_display_name'] = $data['seller_display_name'] ?? null;
        $this->container['charges'] = $data['charges'] ?? null;
        $this->container['package_client_reference_id'] = $data['package_client_reference_id'] ?? null;
        $this->container['items'] = $data['items'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['dimensions'] === null) {
            $invalidProperties[] = "'dimensions' can't be null";
        }
        if ($this->container['weight'] === null) {
            $invalidProperties[] = "'weight' can't be null";
        }
        if ($this->container['insured_value'] === null) {
            $invalidProperties[] = "'insured_value' can't be null";
        }
        if ($this->container['package_client_reference_id'] === null) {
            $invalidProperties[] = "'package_client_reference_id' can't be null";
        }
        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dimensions
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Dimensions
     */
    public function getDimensions()
    {
        return $this->container['dimensions'];
    }

    /**
     * Sets dimensions
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Dimensions $dimensions dimensions
     *
     * @return self
     */
    public function setDimensions($dimensions)
    {
        $this->container['dimensions'] = $dimensions;

        return $this;
    }
    /**
     * Gets weight
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Weight
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Weight $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }
    /**
     * Gets insured_value
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Currency
     */
    public function getInsuredValue()
    {
        return $this->container['insured_value'];
    }

    /**
     * Sets insured_value
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Currency $insured_value insured_value
     *
     * @return self
     */
    public function setInsuredValue($insured_value)
    {
        $this->container['insured_value'] = $insured_value;

        return $this;
    }
    /**
     * Gets is_hazmat
     *
     * @return bool|null
     */
    public function getIsHazmat()
    {
        return $this->container['is_hazmat'];
    }

    /**
     * Sets is_hazmat
     *
     * @param bool|null $is_hazmat When true, the package contains hazardous materials. Defaults to false.
     *
     * @return self
     */
    public function setIsHazmat($is_hazmat)
    {
        $this->container['is_hazmat'] = $is_hazmat;

        return $this;
    }
    /**
     * Gets seller_display_name
     *
     * @return string|null
     */
    public function getSellerDisplayName()
    {
        return $this->container['seller_display_name'];
    }

    /**
     * Sets seller_display_name
     *
     * @param string|null $seller_display_name The seller name displayed on the label.
     *
     * @return self
     */
    public function setSellerDisplayName($seller_display_name)
    {
        $this->container['seller_display_name'] = $seller_display_name;

        return $this;
    }
    /**
     * Gets charges
     *
     * @return \SellingPartnerApi\Model\ShippingV2\ChargeComponent[]|null
     */
    public function getCharges()
    {
        return $this->container['charges'];
    }

    /**
     * Sets charges
     *
     * @param \SellingPartnerApi\Model\ShippingV2\ChargeComponent[]|null $charges A list of charges based on the shipping service charges applied on a package.
     *
     * @return self
     */
    public function setCharges($charges)
    {
        $this->container['charges'] = $charges;

        return $this;
    }
    /**
     * Gets package_client_reference_id
     *
     * @return string
     */
    public function getPackageClientReferenceId()
    {
        return $this->container['package_client_reference_id'];
    }

    /**
     * Sets package_client_reference_id
     *
     * @param string $package_client_reference_id A client provided unique identifier for a package being shipped. This value should be saved by the client to pass as a parameter to the getShipmentDocuments operation.
     *
     * @return self
     */
    public function setPackageClientReferenceId($package_client_reference_id)
    {
        $this->container['package_client_reference_id'] = $package_client_reference_id;

        return $this;
    }
    /**
     * Gets items
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Item[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Item[] $items A list of items.
     *
     * @return self
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Enable iterating over all of the model's attributes in $key => $value format
     *
     * @return \Traversable
     */
    public function getIterator(): \Traversable
    {
        return (function () {
            foreach ($this->container as $key => $value) {
                yield $key => $value;
            }
        })();
    }

    /**
     * Retrieves the property with the given name by converting the property accession
     * to a getter call.
     *
     * @param string $propertyName
     * @return mixed
     */
    public function __get($propertyName)
    {
        // This doesn't make a syntactical difference since PHP is case-insensitive, but
        // makes error messages clearer (e.g. "Call to undefined method getFoo()" rather
        // than "Call to undefined method getfoo()").
        $ucProp = ucfirst($propertyName);
        $getter = "get$ucProp";
        return $this->$getter();
    }

    /**
     * Sets the property with the given name by converting the property accession
     * to a setter call.
     *
     * @param string $propertyName
     * @param mixed $propertyValue
     * @return SellingPartnerApi\Model\ShippingV2\Package
     */
    public function __set($propertyName, $propertyValue)
    {
        $ucProp = ucfirst($propertyName);
        $setter = "set$ucProp";
        $this->$setter($propertyValue);
        return $this;
    }
}


