<?php
/**
 * OrderItemApprovals
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * OrderItemApprovals Class Doc Comment
 *
 * @category Class
 * @description List of item approvals gathered during the approval process.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class OrderItemApprovals extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderItemApprovals';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_item_id' => 'string',
        'approval_type' => '\SellingPartnerApi\Model\OrdersV0\ItemApprovalType',
        'approval_status' => '\SellingPartnerApi\Model\OrdersV0\ItemApprovalStatus',
        'item_approvals' => '\SellingPartnerApi\Model\OrdersV0\ItemApproval[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_item_id' => null,
        'approval_type' => null,
        'approval_status' => null,
        'item_approvals' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_item_id' => 'OrderItemId',
        'approval_type' => 'ApprovalType',
        'approval_status' => 'ApprovalStatus',
        'item_approvals' => 'ItemApprovals'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_item_id' => 'setOrderItemId',
        'approval_type' => 'setApprovalType',
        'approval_status' => 'setApprovalStatus',
        'item_approvals' => 'setItemApprovals'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_item_id' => 'getOrderItemId',
        'approval_type' => 'getApprovalType',
        'approval_status' => 'getApprovalStatus',
        'item_approvals' => 'getItemApprovals'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['order_item_id'] = $data['order_item_id'] ?? null;
        $this->container['approval_type'] = $data['approval_type'] ?? null;
        $this->container['approval_status'] = $data['approval_status'] ?? null;
        $this->container['item_approvals'] = $data['item_approvals'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['order_item_id'] === null) {
            $invalidProperties[] = "'order_item_id' can't be null";
        }
        if ($this->container['approval_type'] === null) {
            $invalidProperties[] = "'approval_type' can't be null";
        }
        if ($this->container['approval_status'] === null) {
            $invalidProperties[] = "'approval_status' can't be null";
        }
        if ($this->container['item_approvals'] === null) {
            $invalidProperties[] = "'item_approvals' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets order_item_id
     *
     * @return string
     */
    public function getOrderItemId()
    {
        return $this->container['order_item_id'];
    }

    /**
     * Sets order_item_id
     *
     * @param string $order_item_id The unique identifier of the order item.
     *
     * @return self
     */
    public function setOrderItemId($order_item_id)
    {
        $this->container['order_item_id'] = $order_item_id;

        return $this;
    }
    /**
     * Gets approval_type
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemApprovalType
     */
    public function getApprovalType()
    {
        return $this->container['approval_type'];
    }

    /**
     * Sets approval_type
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemApprovalType $approval_type approval_type
     *
     * @return self
     */
    public function setApprovalType($approval_type)
    {
        $this->container['approval_type'] = $approval_type;

        return $this;
    }
    /**
     * Gets approval_status
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemApprovalStatus
     */
    public function getApprovalStatus()
    {
        return $this->container['approval_status'];
    }

    /**
     * Sets approval_status
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemApprovalStatus $approval_status approval_status
     *
     * @return self
     */
    public function setApprovalStatus($approval_status)
    {
        $this->container['approval_status'] = $approval_status;

        return $this;
    }
    /**
     * Gets item_approvals
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ItemApproval[]
     */
    public function getItemApprovals()
    {
        return $this->container['item_approvals'];
    }

    /**
     * Sets item_approvals
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ItemApproval[] $item_approvals item_approvals
     *
     * @return self
     */
    public function setItemApprovals($item_approvals)
    {
        $this->container['item_approvals'] = $item_approvals;

        return $this;
    }
}


