<?php
/**
 * UpdateScheduledPackagesRequest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Easy Ship
 *
 * The Selling Partner API for Easy Ship helps you build applications that help sellers manage and ship Amazon Easy Ship orders. Your Easy Ship applications can: * Get available time slots for packages to be scheduled for delivery. * Schedule, reschedule, and cancel Easy Ship orders. * Print labels, invoices, and warranties. See the [Marketplace Support Table](https://developer-docs.amazon.com/sp-api/docs/easyship-api-v2022-03-23-use-case-guide#marketplace-support-table) for the differences in Easy Ship operations by marketplace.
 *
 * The version of the OpenAPI document: 2022-03-23
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\EasyShipV20220323;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * UpdateScheduledPackagesRequest Class Doc Comment
 *
 * @category Class
 * @description The request schema for the `updateScheduledPackages` operation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class UpdateScheduledPackagesRequest extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateScheduledPackagesRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_id' => 'string',
        'update_package_details_list' => '\SellingPartnerApi\Model\EasyShipV20220323\UpdatePackageDetails[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_id' => null,
        'update_package_details_list' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_id' => 'marketplaceId',
        'update_package_details_list' => 'updatePackageDetailsList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_id' => 'setMarketplaceId',
        'update_package_details_list' => 'setUpdatePackageDetailsList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_id' => 'getMarketplaceId',
        'update_package_details_list' => 'getUpdatePackageDetailsList'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['update_package_details_list'] = $data['update_package_details_list'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        if ((mb_strlen($this->container['marketplace_id']) > 255)) {
            $invalidProperties[] = "invalid value for 'marketplace_id', the character length must be smaller than or equal to 255.";
        }

        if ((mb_strlen($this->container['marketplace_id']) < 1)) {
            $invalidProperties[] = "invalid value for 'marketplace_id', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['update_package_details_list'] === null) {
            $invalidProperties[] = "'update_package_details_list' can't be null";
        }
        if ((count($this->container['update_package_details_list']) > 500)) {
            $invalidProperties[] = "invalid value for 'update_package_details_list', number of items must be less than or equal to 500.";
        }

        if ((count($this->container['update_package_details_list']) < 1)) {
            $invalidProperties[] = "invalid value for 'update_package_details_list', number of items must be greater than or equal to 1.";
        }

        return $invalidProperties;
    }


    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id A string of up to 255 characters.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        if ((mb_strlen($marketplace_id) > 255)) {
            throw new \InvalidArgumentException('invalid length for $marketplace_id when calling UpdateScheduledPackagesRequest., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($marketplace_id) < 1)) {
            throw new \InvalidArgumentException('invalid length for $marketplace_id when calling UpdateScheduledPackagesRequest., must be bigger than or equal to 1.');
        }

        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets update_package_details_list
     *
     * @return \SellingPartnerApi\Model\EasyShipV20220323\UpdatePackageDetails[]
     */
    public function getUpdatePackageDetailsList()
    {
        return $this->container['update_package_details_list'];
    }

    /**
     * Sets update_package_details_list
     *
     * @param \SellingPartnerApi\Model\EasyShipV20220323\UpdatePackageDetails[] $update_package_details_list A list of package update details.
     *
     * @return self
     */
    public function setUpdatePackageDetailsList($update_package_details_list)
    {

        if ((count($update_package_details_list) > 500)) {
            throw new \InvalidArgumentException('invalid value for $update_package_details_list when calling UpdateScheduledPackagesRequest., number of items must be less than or equal to 500.');
        }
        if ((count($update_package_details_list) < 1)) {
            throw new \InvalidArgumentException('invalid length for $update_package_details_list when calling UpdateScheduledPackagesRequest., number of items must be greater than or equal to 1.');
        }
        $this->container['update_package_details_list'] = $update_package_details_list;

        return $this;
    }
}


